/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.organization;

import java.util.List;
import java.util.Map;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.identity.User;
import org.bonitasoft.engine.identity.UserCreator;
import org.bonitasoft.engine.identity.UserUpdater;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.identity.UserItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.organization.UserCreatorConverter;
import org.bonitasoft.web.rest.server.datastore.organization.UserFilterCreator;
import org.bonitasoft.web.rest.server.datastore.organization.UserItemConverter;
import org.bonitasoft.web.rest.server.datastore.organization.UserSearchAttributeConverter;
import org.bonitasoft.web.rest.server.datastore.organization.UserUpdaterConverter;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.bonitasoft.web.rest.server.engineclient.EngineAPIAccessor;
import org.bonitasoft.web.rest.server.engineclient.EngineClientFactory;
import org.bonitasoft.web.rest.server.engineclient.ProcessEngineClient;
import org.bonitasoft.web.rest.server.engineclient.UserEngineClient;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.exception.APIAttributeException;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class UserDatastore
extends CommonDatastore<UserItem, User>
implements DatastoreHasAdd<UserItem>,
DatastoreHasGet<UserItem>,
DatastoreHasSearch<UserItem>,
DatastoreHasUpdate<UserItem>,
DatastoreHasDelete {
    protected EngineClientFactory engineClientFactory;
    protected UserItemConverter userItemConverter = new UserItemConverter();

    public UserDatastore(APISession engineSession) {
        super(engineSession);
        this.engineClientFactory = new EngineClientFactory(new EngineAPIAccessor(engineSession));
    }

    @Override
    public UserItem add(UserItem user) {
        UserCreator userCreator = new UserCreatorConverter().convert(user);
        User createdUser = this.getUserEngineClient().create(userCreator);
        return this.userItemConverter.convert(createdUser);
    }

    @Override
    public UserItem update(APIID id, Map<String, String> attributes) {
        UserUpdater userUpdater = new UserUpdaterConverter().convert(attributes, this.getBonitaHomeFolderAccessor());
        User user = this.getUserEngineClient().update(id.toLong(), userUpdater);
        return this.userItemConverter.convert(user);
    }

    BonitaHomeFolderAccessor getBonitaHomeFolderAccessor() {
        return new BonitaHomeFolderAccessor();
    }

    @Override
    public UserItem get(APIID id) {
        User user = this.getUserEngineClient().get(id.toLong());
        return this.userItemConverter.convert(user);
    }

    @Override
    public ItemSearchResult<UserItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        if (filters.containsKey("process_id")) {
            String processId = filters.get("process_id");
            filters.remove("process_id");
            return this.searchUsersWhoCanStartProcess(processId, page, resultsByPage, search, filters, orders);
        }
        if (filters.containsKey("task_id")) {
            String taskId = filters.get("task_id");
            filters.remove("task_id");
            return this.searchUsersWhoCanPerformTask(taskId, page, resultsByPage, search, filters, orders);
        }
        return this.searchUsers(page, resultsByPage, search, filters, orders);
    }

    private ItemSearchResult<UserItem> searchUsers(int page, int resultsByPage, String search, Map<String, String> filters, String orders) {
        SearchOptionsCreator searchOptionsCreator = this.buildSearchOptionCreator(page, resultsByPage, search, filters, orders);
        SearchResult<User> engineSearchResults = this.getUserEngineClient().search(searchOptionsCreator.create());
        return new ItemSearchResult<UserItem>(page, resultsByPage, engineSearchResults.getCount(), this.userItemConverter.convert(engineSearchResults.getResult()));
    }

    protected ItemSearchResult<UserItem> searchUsersWhoCanStartProcess(String processId, int page, int resultsByPage, String search, Map<String, String> filters, String orders) {
        SearchResult engineSearchResults;
        SearchOptionsCreator searchOptionsCreator = this.buildSearchOptionCreator(page, resultsByPage, search, filters, orders);
        try {
            engineSearchResults = this.getProcessEngineClient().getProcessApi().searchUsersWhoCanStartProcessDefinition(Long.valueOf(processId).longValue(), searchOptionsCreator.create());
        }
        catch (NumberFormatException e) {
            throw new APIAttributeException("process_id", "Cannot convert process id: " + processId + " into long.");
        }
        catch (SearchException e) {
            throw new APIException(e);
        }
        return new ItemSearchResult<UserItem>(page, resultsByPage, engineSearchResults.getCount(), this.userItemConverter.convert(engineSearchResults.getResult()));
    }

    protected ItemSearchResult<UserItem> searchUsersWhoCanPerformTask(String taskId, int page, int resultsByPage, String search, Map<String, String> filters, String orders) {
        SearchResult engineSearchResults;
        try {
            SearchOptionsCreator searchOptionsCreator = this.buildSearchOptionCreator(page, resultsByPage, search, filters, orders);
            engineSearchResults = this.getProcessEngineClient().getProcessApi().searchUsersWhoCanExecutePendingHumanTask(Long.valueOf(taskId).longValue(), searchOptionsCreator.create());
        }
        catch (NumberFormatException e) {
            throw new APIAttributeException("task_id", "Cannot convert human task id: " + taskId + " into long.");
        }
        return new ItemSearchResult<UserItem>(page, resultsByPage, engineSearchResults.getCount(), this.userItemConverter.convert(engineSearchResults.getResult()));
    }

    protected SearchOptionsCreator buildSearchOptionCreator(int page, int resultsByPage, String search, Map<String, String> filters, String orders) {
        return new SearchOptionsCreator(page, resultsByPage, search, new Sorts(orders, new UserSearchAttributeConverter()), new Filters(filters, new UserFilterCreator(new UserSearchAttributeConverter())));
    }

    @Override
    public void delete(List<APIID> ids) {
        this.getUserEngineClient().delete(APIID.toLongList(ids));
    }

    UserEngineClient getUserEngineClient() {
        return this.engineClientFactory.createUserEngineClient();
    }

    ProcessEngineClient getProcessEngineClient() {
        return this.engineClientFactory.createProcessEngineClient();
    }

    @Override
    protected UserItem convertEngineToConsoleItem(User user) {
        throw new RuntimeException("Unimplemented method");
    }
}

