/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.page;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.bonitasoft.console.common.server.page.CustomPageService;
import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstantsUtils;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.common.server.utils.UnzipUtil;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.io.IOUtil;
import org.bonitasoft.engine.page.Page;
import org.bonitasoft.engine.page.PageCreator;
import org.bonitasoft.engine.page.PageNotFoundException;
import org.bonitasoft.engine.page.PageUpdater;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.extension.page.PageResourceProvider;
import org.bonitasoft.web.rest.model.portal.page.PageItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.page.CustomPageContentValidator;
import org.bonitasoft.web.rest.server.datastore.page.InvalidPageZipContentException;
import org.bonitasoft.web.rest.server.datastore.page.PageFilterCreator;
import org.bonitasoft.web.rest.server.datastore.page.PageItemConverter;
import org.bonitasoft.web.rest.server.datastore.page.PageSearchDescriptorConverter;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageDatastore
extends CommonDatastore<PageItem, Page>
implements DatastoreHasAdd<PageItem>,
DatastoreHasUpdate<PageItem>,
DatastoreHasGet<PageItem>,
DatastoreHasSearch<PageItem>,
DatastoreHasDelete {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PageDatastore.class.getName());
    public static final String UNMAPPED_ATTRIBUTE_ZIP_FILE = "pageZip";
    static final String PAGE_TOKEN_PREFIX = "custompage_";
    protected final WebBonitaConstantsUtils constants;
    protected final PageAPI pageAPI;
    protected final CustomPageService customPageService;
    private final BonitaHomeFolderAccessor tenantFolder;
    private final CustomPageContentValidator pageContentValidator;
    private static boolean hasShownIsHiddenLog = false;

    public PageDatastore(APISession engineSession, WebBonitaConstantsUtils constantsValue, PageAPI pageAPI, CustomPageService customPageService, BonitaHomeFolderAccessor tenantFolder) {
        super(engineSession);
        this.constants = constantsValue;
        this.pageAPI = pageAPI;
        this.customPageService = customPageService;
        this.tenantFolder = tenantFolder;
        this.pageContentValidator = new CustomPageContentValidator();
    }

    @Override
    @Deprecated(since="9.0.0")
    public PageItem add(PageItem pageItem) {
        String zipFileAttribute = pageItem.getAttributeValue(UNMAPPED_ATTRIBUTE_ZIP_FILE);
        String[] filenames = zipFileAttribute.split("::");
        String filename = filenames[0];
        String originalFileName = this.getOriginalFilename(filenames, filename, pageItem.getAttributes());
        pageItem.setContentName(originalFileName);
        try {
            APISession engineSession = this.getEngineSession();
            File zipFile = this.tenantFolder.getTempFile(filename);
            File unzipPageTempFolder = this.unzipContentFile(zipFile);
            this.pageContentValidator.validate(unzipPageTempFolder);
            Page page = this.createEnginePage(pageItem, zipFile);
            PageItem addedPage = this.convertEngineToConsoleItem(page);
            PageResourceProvider pageResourceProvider = this.customPageService.getPageResourceProvider(page);
            this.customPageService.writePageToPageDirectory(page, pageResourceProvider, unzipPageTempFolder, engineSession);
            this.deleteTempDirectory(unzipPageTempFolder);
            PageItem pageItem2 = addedPage;
            return pageItem2;
        }
        catch (IOException | BonitaException | InvalidPageZipContentException e) {
            throw new APIException(e);
        }
        finally {
            this.tenantFolder.removeUploadedTempContent(filename);
        }
    }

    protected File unzipContentFile(File zipFile) throws InvalidPageZipContentException {
        File unzipPageTempFolder = null;
        try {
            Random randomGen = new Random();
            int tempPageFolder = randomGen.nextInt();
            unzipPageTempFolder = new File(this.constants.getTempFolder(), String.valueOf(tempPageFolder));
            UnzipUtil.unzip(zipFile, unzipPageTempFolder.getPath(), false);
        }
        catch (Exception e) {
            this.deleteTempDirectory(unzipPageTempFolder);
            throw new InvalidPageZipContentException("Unable to unzip the page content.", e);
        }
        return unzipPageTempFolder;
    }

    protected boolean isPageTokenValid(String urlToken) {
        return urlToken.matches("custompage_\\p{Alnum}+");
    }

    protected void deleteTempDirectory(File unzipPage) {
        try {
            if (unzipPage.isDirectory()) {
                this.IOUtilDeleteDir(unzipPage);
            }
        }
        catch (IOException e) {
            throw new APIException(e);
        }
    }

    protected void IOUtilDeleteDir(File unzipPage) throws IOException {
        IOUtil.deleteDir((File)unzipPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Page createEnginePage(PageItem pageItem, File zipFile) throws CreationException, IOException, UpdateException {
        try {
            byte[] zipContent = this.readZipFile(zipFile);
            Page page = this.pageAPI.createPage(pageItem.getContentName(), zipContent);
            if (pageItem.getProcessId() != null) {
                PageUpdater pageUpdater = new PageUpdater();
                pageUpdater.setProcessDefinitionId(pageItem.getProcessId().toLong());
                if (pageItem.getContentType() != null) {
                    pageUpdater.setContentType(pageItem.getContentType());
                }
                page = this.pageAPI.updatePage(page.getId(), pageUpdater);
            }
            Page page2 = page;
            return page2;
        }
        finally {
            zipFile.delete();
        }
    }

    protected byte[] readZipFile(File zipFile) throws IOException {
        return FileUtils.readFileToByteArray((File)zipFile);
    }

    protected PageCreator buildPageCreatorFrom(PageItem pageItem) {
        PageCreator pageCreator = new PageCreator(pageItem.getUrlToken(), pageItem.getContentName());
        pageCreator.setDescription(pageItem.getDescription());
        pageCreator.setDisplayName(pageItem.getDisplayName());
        return pageCreator;
    }

    @Override
    public PageItem get(APIID id) {
        try {
            Page pageItem = this.pageAPI.getPage(id.toLong().longValue());
            return this.convertEngineToConsoleItem(pageItem);
        }
        catch (PageNotFoundException e) {
            throw new APIItemNotFoundException("page", id);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public void delete(List<APIID> ids) {
        try {
            for (APIID id : ids) {
                Page page = this.pageAPI.getPage(id.toLong().longValue());
                APISession engineSession = this.getEngineSession();
                PageResourceProvider pageResourceProvider = this.customPageService.getPageResourceProvider(page);
                this.customPageService.ensurePageFolderIsUpToDate(engineSession, pageResourceProvider);
                this.pageAPI.deletePage(id.toLong().longValue());
                this.customPageService.removePageLocally(pageResourceProvider);
            }
        }
        catch (IOException | BonitaException e) {
            throw new APIException(e);
        }
    }

    protected List<Long> APIIdsToLong(List<APIID> ids) {
        ArrayList<Long> result = new ArrayList<Long>(ids.size());
        for (APIID id : ids) {
            result.add(id.toLong());
        }
        return result;
    }

    @Override
    public ItemSearchResult<PageItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsCreator creator = this.makeSearchOptionCreator(page, resultsByPage, search, orders, filters);
        try {
            SearchResult<Page> searchResult = this.runSearch(creator);
            return new ItemSearchResult<PageItem>(page, resultsByPage, searchResult.getCount(), this.convertEngineToConsoleItemsList(searchResult.getResult()));
        }
        catch (SearchException e) {
            throw new APIException(e);
        }
    }

    protected PageSearchDescriptorConverter getSearchDescriptorConverter() {
        return new PageSearchDescriptorConverter();
    }

    protected SearchOptionsCreator makeSearchOptionCreator(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        if (filters.containsKey("isHidden")) {
            if (!hasShownIsHiddenLog && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Parameter \"isHidden\" for page search is deprecated and will be removed in a future release");
                hasShownIsHiddenLog = true;
            }
            filters.remove("isHidden");
        }
        SearchOptionsCreator searchOptionsCreator = new SearchOptionsCreator(page, resultsByPage, search, new Sorts(orders, this.getSearchDescriptorConverter()), new Filters(filters, new PageFilterCreator(this.getSearchDescriptorConverter())));
        SearchOptionsBuilder builder = searchOptionsCreator.getBuilder();
        if (filters.containsKey("contentType") && "processPage".equalsIgnoreCase(filters.get("contentType"))) {
            builder.leftParenthesis().filter("contentType", (Serializable)((Object)"form")).or().filter("contentType", (Serializable)((Object)"page")).rightParenthesis();
        } else {
            this.addStringFilterToSearchBuilder(filters, builder, "contentType", "contentType");
        }
        return searchOptionsCreator;
    }

    protected SearchResult<Page> runSearch(SearchOptionsCreator creator) throws SearchException {
        return this.pageAPI.searchPages(creator.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated(since="9.0.0")
    public PageItem update(APIID id, Map<String, String> attributes) {
        String filename = null;
        File zipFile = null;
        try {
            String zipFileAttribute;
            Long pageId = id.toLong();
            Page page = this.pageAPI.getPage(pageId.longValue());
            PageItem updatedPage = null;
            if (attributes.containsKey(UNMAPPED_ATTRIBUTE_ZIP_FILE) && (zipFileAttribute = attributes.get(UNMAPPED_ATTRIBUTE_ZIP_FILE)) != null && !zipFileAttribute.isEmpty()) {
                String[] filenames = zipFileAttribute.split("::");
                filename = filenames[0];
                String originalFileName = this.getOriginalFilename(filenames, filename, attributes);
                APISession engineSession = this.getEngineSession();
                zipFile = this.tenantFolder.getTempFile(filename);
                File unzipPageTempFolder = this.unzipContentFile(zipFile);
                this.pageContentValidator.validate(unzipPageTempFolder);
                try {
                    this.updatePageContent(page, zipFile);
                    PageUpdater pageUpdater = new PageUpdater();
                    pageUpdater.setContentName(originalFileName);
                    page = this.pageAPI.updatePage(pageId.longValue(), pageUpdater);
                    updatedPage = this.convertEngineToConsoleItem(page);
                }
                finally {
                    PageResourceProvider pageResourceProvider = this.customPageService.getPageResourceProvider(page);
                    this.customPageService.writePageToPageDirectory(page, pageResourceProvider, unzipPageTempFolder, engineSession);
                    this.deleteTempDirectory(unzipPageTempFolder);
                }
            }
            PageItem pageItem = updatedPage;
            return pageItem;
        }
        catch (IOException | BonitaException | InvalidPageZipContentException e) {
            throw new APIException(e);
        }
        finally {
            if (filename != null) {
                this.tenantFolder.removeUploadedTempContent(filename);
            }
            if (zipFile != null) {
                zipFile.delete();
            }
        }
    }

    protected String getOriginalFilename(String[] filenames, String tempFilename, Map<String, String> attributes) {
        String originalFileName = filenames.length > 1 ? filenames[1] : attributes.getOrDefault("contentName", tempFilename);
        return originalFileName;
    }

    protected void updatePageContent(Page page, File zipFile) throws IOException, CompilationFailedException, BonitaException {
        if (zipFile != null) {
            PageResourceProvider pageResourceProvider = this.customPageService.getPageResourceProvider(page);
            this.customPageService.ensurePageFolderIsUpToDate(this.getEngineSession(), pageResourceProvider);
            this.pageAPI.updatePageContent(page.getId(), FileUtils.readFileToByteArray((File)zipFile));
        }
        this.customPageService.removePageLocally(page);
    }

    @Override
    protected PageItem convertEngineToConsoleItem(Page item) {
        if (item != null) {
            return new PageItemConverter().convert(item);
        }
        return null;
    }
}

