/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.profile;

import org.bonitasoft.engine.profile.Profile;
import org.bonitasoft.web.rest.model.portal.profile.ProfileItem;
import org.bonitasoft.web.rest.server.datastore.converter.ItemConverter;

public class ProfileItemConverter
extends ItemConverter<ProfileItem, Profile> {
    public static final String USER_PROFILE_NAME = "User";
    public static final String ADMIN_PROFILE_NAME = "Administrator";
    public static final String PROCESSMANAGER_PROFILE_NAME = "Process manager";
    public static final String TEAMMANAGER_PROFILE_NAME = "Team manager";
    public static final String USER_PROFILE_ICONPATH = "icons/profiles/profileUser.png";
    public static final String ADMIN_PROFILE_ICONPATH = "icons/profiles/profileAdmin.png";
    public static final String PROCESSMANAGER_PROFILE_ICONPATH = "icons/profiles/profileProcessManager.png";
    public static final String TEAMMANAGER_PROFILE_ICONPATH = "icons/profiles/profileTeamManager.png";
    public static final String DEFAULT_PROFILE_ICONPATH = "icons/profiles/profileDefault.png";

    @Override
    public ProfileItem convert(Profile profile) {
        ProfileItem item = new ProfileItem();
        item.setId(profile.getId());
        item.setName(profile.getName());
        item.setDescription(profile.getDescription());
        item.setIsDefault(profile.isDefault());
        item.setIcon(this.getIconPath(profile.getName()));
        item.setUpdatedByUserId(profile.getLastUpdatedBy());
        item.setLastUpdateDate(profile.getLastUpdateDate());
        item.setCreatedByUserId(profile.getCreatedBy());
        item.setCreationDate(profile.getCreationDate());
        return item;
    }

    protected String getIconPath(String profileName) {
        if (USER_PROFILE_NAME.equals(profileName)) {
            return USER_PROFILE_ICONPATH;
        }
        if (ADMIN_PROFILE_NAME.equals(profileName)) {
            return ADMIN_PROFILE_ICONPATH;
        }
        if (PROCESSMANAGER_PROFILE_NAME.equals(profileName)) {
            return PROCESSMANAGER_PROFILE_ICONPATH;
        }
        if (TEAMMANAGER_PROFILE_NAME.equals(profileName)) {
            return TEAMMANAGER_PROFILE_ICONPATH;
        }
        return DEFAULT_PROFILE_ICONPATH;
    }
}

