/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.framework.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.i18n.AbstractI18n;

public class JacksonDeserializer {
    private final ObjectMapper mapper = new ObjectMapper();

    public <T> T deserialize(String json, Class<T> clazz) {
        return this.deserialize(json, this.mapper.getTypeFactory().constructType(clazz));
    }

    public <T> List<T> deserializeList(String json, Class<T> clazz) {
        return (List)this.deserialize(json, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, clazz));
    }

    private <T> T deserialize(String json, JavaType javaType) {
        try {
            return (T)this.mapper.readValue(json.getBytes(), javaType);
        }
        catch (JsonParseException e) {
            throw new APIException(AbstractI18n.t_("Can't parse json, non-well formed content"), (Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new APIException(AbstractI18n.t_("Json can't be mapped to " + javaType.getRawClass().getName()), (Throwable)e);
        }
        catch (IOException e) {
            throw new APIException(e);
        }
    }

    public <T> T convertValue(Object fromValue, Class<?> toValue) {
        return (T)this.mapper.convertValue(fromValue, toValue);
    }
}

