/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.filter;

import java.io.IOException;
import java.util.LinkedList;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.console.common.server.auth.AuthenticationManager;
import org.bonitasoft.console.common.server.auth.AuthenticationManagerFactory;
import org.bonitasoft.console.common.server.auth.AuthenticationManagerNotFoundException;
import org.bonitasoft.console.common.server.filter.ExcludingPatternFilter;
import org.bonitasoft.console.common.server.login.HttpServletRequestAccessor;
import org.bonitasoft.console.common.server.login.filter.AlreadyLoggedInRule;
import org.bonitasoft.console.common.server.login.filter.AuthenticationRule;
import org.bonitasoft.console.common.server.login.filter.EngineUserNotFoundOrInactive;
import org.bonitasoft.console.common.server.login.filter.PlatformUnderMaintenanceException;
import org.bonitasoft.console.common.server.login.utils.LoginUrl;
import org.bonitasoft.console.common.server.login.utils.RedirectUrl;
import org.bonitasoft.console.common.server.login.utils.RedirectUrlBuilder;
import org.bonitasoft.console.common.server.utils.SessionUtil;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.api.TenantAdministrationAPI;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.session.APISession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFilter
extends ExcludingPatternFilter {
    protected static final String AUTHENTICATION_FILTER_EXCLUDED_PAGES_PATTERN = "^/(bonita/)?(login.jsp$)|(apps/.+/API/)|(portal/resource/.+/API/)";
    protected static final String REDIRECT_PARAM = "redirectWhenUnauthorized";
    protected static final String USER_NOT_FOUND_JSP = "/usernotfound.jsp";
    public static final String ERROR_PAGE_REQUEST_PATH_REGEX = "/portal/resource/app/appDirectoryBonita/error-\\d+/(content|theme)/.*";
    protected boolean redirectWhenUnauthorized;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AuthenticationFilter.class.getName());
    private final LinkedList<AuthenticationRule> rules = new LinkedList();

    public AuthenticationFilter() {
        this.addRules();
    }

    protected void addRules() {
        this.addRule(new AlreadyLoggedInRule());
    }

    protected void addRule(AuthenticationRule rule) {
        this.rules.add(rule);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String redirectInitParam = filterConfig.getInitParameter(REDIRECT_PARAM);
        this.redirectWhenUnauthorized = redirectInitParam != null ? Boolean.parseBoolean(redirectInitParam) : true;
        super.init(filterConfig);
    }

    @Override
    public String getDefaultExcludedPages() {
        return AUTHENTICATION_FILTER_EXCLUDED_PAGES_PATTERN;
    }

    @Override
    public void proceedWithFiltering(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequestAccessor requestAccessor = new HttpServletRequestAccessor((HttpServletRequest)request);
        this.doAuthenticationFiltering(requestAccessor, (HttpServletResponse)response, chain);
    }

    protected void doAuthenticationFiltering(HttpServletRequestAccessor requestAccessor, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        try {
            if (!this.isAuthorized(requestAccessor, response, chain)) {
                if (!this.isAccessingPlatformAPIWithAPISession(requestAccessor)) {
                    this.cleanHttpSession(requestAccessor.getHttpSession());
                }
                if (this.redirectWhenUnauthorized && requestAccessor.asHttpServletRequest().getMethod().equals("GET")) {
                    response.sendRedirect(this.createLoginPageUrl(requestAccessor).getLocation());
                } else {
                    response.setStatus(401);
                }
            }
        }
        catch (PlatformUnderMaintenanceException e) {
            this.handlePlatformUnderMaintenanceException(requestAccessor, response, e);
        }
        catch (EngineUserNotFoundOrInactive e) {
            this.handleUserNotFoundOrInactiveException(requestAccessor, response, e);
        }
        catch (BonitaException e) {
            this.handleBonitaException(requestAccessor, response, e);
        }
    }

    protected boolean isAccessingPlatformAPIWithAPISession(HttpServletRequestAccessor requestAccessor) {
        String requestPath = requestAccessor.asHttpServletRequest().getServletPath() + requestAccessor.asHttpServletRequest().getPathInfo();
        return requestPath.matches("^/(API|APIToolkit)/platform/.*") && requestAccessor.getApiSession() != null;
    }

    protected boolean isAuthorized(HttpServletRequestAccessor requestAccessor, HttpServletResponse response, FilterChain chain) throws ServletException, IOException, PlatformUnderMaintenanceException, BonitaException {
        for (AuthenticationRule rule : this.getRules()) {
            if (!rule.doAuthorize(requestAccessor, response)) continue;
            this.checkPlatformMaintenanceState(requestAccessor);
            rule.proceedWithRequest(chain, requestAccessor.asHttpServletRequest(), response);
            return true;
        }
        return false;
    }

    protected void checkPlatformMaintenanceState(HttpServletRequestAccessor requestAccessor) throws PlatformUnderMaintenanceException, BonitaException {
        try {
            if (this.redirectWhenUnauthorized && !this.isLoggedInAsTechnicalUser(requestAccessor) && this.isPlaformInMaintenance(requestAccessor) && !this.isAccessingErrorPage(requestAccessor)) {
                throw new PlatformUnderMaintenanceException("Platform is under Maintenance");
            }
        }
        catch (BonitaException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Error while checking platform maintenance state : " + e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    protected boolean isAccessingErrorPage(HttpServletRequestAccessor requestAccessor) {
        HttpServletRequest httpRequest = requestAccessor.asHttpServletRequest();
        if (httpRequest.getPathInfo() != null) {
            String requestPath = httpRequest.getServletPath() + httpRequest.getPathInfo();
            return requestPath.matches(ERROR_PAGE_REQUEST_PATH_REGEX);
        }
        return false;
    }

    protected boolean isLoggedInAsTechnicalUser(HttpServletRequestAccessor requestAccessor) {
        return requestAccessor.getApiSession() != null && requestAccessor.getApiSession().isTechnicalUser();
    }

    protected boolean isPlaformInMaintenance(HttpServletRequestAccessor requestAccessor) throws BonitaException {
        TenantAdministrationAPI tenantAdministrationAPI = TenantAPIAccessor.getTenantAdministrationAPI((APISession)requestAccessor.getApiSession());
        return tenantAdministrationAPI.isPaused();
    }

    protected void handleUserNotFoundOrInactiveException(HttpServletRequestAccessor requestAccessor, HttpServletResponse response, EngineUserNotFoundOrInactive e) throws ServletException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("redirection to user not found page : " + e.getMessage(), (Throwable)e);
        }
        if (this.redirectWhenUnauthorized && requestAccessor.asHttpServletRequest().getMethod().equals("GET")) {
            this.redirectTo(requestAccessor, response, USER_NOT_FOUND_JSP);
        } else {
            response.setStatus(403);
        }
    }

    protected void handlePlatformUnderMaintenanceException(HttpServletRequestAccessor requestAccessor, HttpServletResponse response, PlatformUnderMaintenanceException e) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Redirection to maintenance page : " + e.getMessage(), (Throwable)e);
        }
        if (this.redirectWhenUnauthorized && requestAccessor.asHttpServletRequest().getMethod().equals("GET")) {
            response.sendError(503, "Platform is under maintenance");
        } else {
            response.setStatus(503);
        }
    }

    protected void handleBonitaException(HttpServletRequestAccessor requestAccessor, HttpServletResponse response, BonitaException e) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("redirection to 500 error page : " + e.getMessage(), (Throwable)e);
        }
        if (this.redirectWhenUnauthorized && requestAccessor.asHttpServletRequest().getMethod().equals("GET")) {
            response.sendError(500);
        } else {
            response.setStatus(500);
        }
    }

    protected void redirectTo(HttpServletRequestAccessor request, HttpServletResponse response, String pagePath) throws ServletException {
        block2: {
            try {
                response.sendRedirect(request.asHttpServletRequest().getContextPath() + pagePath);
            }
            catch (IOException e) {
                if (!LOGGER.isInfoEnabled()) break block2;
                LOGGER.info(e.getMessage());
            }
        }
    }

    protected LinkedList<AuthenticationRule> getRules() {
        return this.rules;
    }

    @Override
    public void destroy() {
    }

    protected AuthenticationManager getAuthenticationManager() throws ServletException {
        try {
            return AuthenticationManagerFactory.getAuthenticationManager();
        }
        catch (AuthenticationManagerNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected RedirectUrl makeRedirectUrl(HttpServletRequestAccessor httpRequest) {
        boolean hasRedirectionURL = StringUtils.isNotBlank((CharSequence)httpRequest.getRedirectUrl());
        RedirectUrlBuilder builder = new RedirectUrlBuilder(hasRedirectionURL ? httpRequest.getRedirectUrl() : httpRequest.getRequestedUri());
        builder.appendParameters(httpRequest.getParameterMap());
        return builder.build();
    }

    protected LoginUrl createLoginPageUrl(HttpServletRequestAccessor requestAccessor) throws ServletException {
        return new LoginUrl(this.getAuthenticationManager(), this.makeRedirectUrl(requestAccessor).getUrl(), requestAccessor);
    }

    protected void cleanHttpSession(HttpSession session) {
        SessionUtil.sessionLogout(session);
    }
}

