/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.filter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.console.common.server.filter.ExcludingPatternFilter;
import org.bonitasoft.console.common.server.filter.MultiReadHttpServletRequest;
import org.bonitasoft.console.common.server.preferences.properties.PropertiesFactory;
import org.bonitasoft.console.common.server.utils.SessionUtil;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.api.permission.APICallContext;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ExecutionException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.TenantStatusException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.engine.session.PlatformSession;
import org.bonitasoft.web.rest.server.framework.utils.RestRequestParser;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAPIAuthorizationFilter
extends ExcludingPatternFilter {
    public static final String PLATFORM_API_URI_REGEXP = "^/(API|APIToolkit)/platform/.*";
    protected static final String AUTHORIZATION_FILTER_EXCLUDED_PAGES_PATTERN = "^/(bonita/)?((apps/.+/)|(portal/resource/.+/))?(API|APIToolkit)/system/(i18ntranslation|feature)";
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)RestAPIAuthorizationFilter.class.getName());

    @Override
    public void proceedWithFiltering(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException {
        Object httpServletRequest = (HttpServletRequest)request;
        try {
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)httpServletRequest)) {
                httpServletRequest = new MultiReadHttpServletRequest((HttpServletRequest)httpServletRequest);
            }
            String pathInfo = Optional.ofNullable(httpServletRequest.getPathInfo()).orElse("");
            String requestPath = httpServletRequest.getServletPath() + pathInfo;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            boolean isAuthorized = requestPath.matches(PLATFORM_API_URI_REGEXP) ? this.platformAPIsCheck((HttpServletRequest)httpServletRequest, httpServletResponse) : this.tenantAPIsCheck((HttpServletRequest)httpServletRequest, httpServletResponse);
            if (isAuthorized) {
                chain.doFilter((ServletRequest)httpServletRequest, response);
            }
        }
        catch (InvalidSessionException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Invalid Bonita engine session: {}", (Object)e.getMessage());
            }
            SessionUtil.sessionLogout(httpServletRequest.getSession());
            ((HttpServletResponse)response).setStatus(401);
        }
        catch (TenantStatusException e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Platform is probably under Maintenance : " + e.getMessage());
            }
            ((HttpServletResponse)response).setStatus(503);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (e instanceof APIException) {
                throw new ServletException((Throwable)e);
            }
            throw new ServletException((Throwable)new APIException(e));
        }
    }

    protected boolean tenantAPIsCheck(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        APISession apiSession = (APISession)httpRequest.getSession().getAttribute("apiSession");
        try {
            if (apiSession == null) {
                httpResponse.setStatus(401);
                httpResponse.flushBuffer();
                return false;
            }
            if (!this.checkPermissions(httpRequest)) {
                httpResponse.setStatus(403);
                httpResponse.flushBuffer();
                return false;
            }
            return true;
        }
        catch (InvalidSessionException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Invalid Bonita engine session.", (Throwable)e);
            }
            httpResponse.setStatus(401);
            SessionUtil.sessionLogout(httpRequest.getSession());
            httpResponse.flushBuffer();
            return false;
        }
    }

    protected boolean platformAPIsCheck(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        PlatformSession platformSession = (PlatformSession)httpRequest.getSession().getAttribute("platformSession");
        if (platformSession != null) {
            return true;
        }
        httpResponse.setStatus(401);
        return false;
    }

    protected boolean checkPermissions(HttpServletRequest request) throws ServletException {
        RestRequestParser restRequestParser = new RestRequestParser(request).invoke();
        return this.checkPermissions(request, restRequestParser.getApiName(), restRequestParser.getResourceName(), restRequestParser.getResourceQualifiers());
    }

    protected boolean checkPermissions(HttpServletRequest request, String apiName, String resourceName, APIID resourceQualifiers) throws ServletException {
        String method = request.getMethod();
        HttpSession session = request.getSession();
        APISession apiSession = (APISession)session.getAttribute("apiSession");
        boolean apiAuthorizationsCheckEnabled = this.isApiAuthorizationsCheckEnabled();
        if (!apiAuthorizationsCheckEnabled || apiSession.isTechnicalUser()) {
            return true;
        }
        String resourceQualifiersAsString = resourceQualifiers != null ? resourceQualifiers.toString() : null;
        String body = this.getRequestBody(request);
        APICallContext apiCallContext = new APICallContext(method, apiName, resourceName, resourceQualifiersAsString, request.getQueryString(), body);
        if (this.isAlwaysAuthorizedResource(apiCallContext)) {
            return true;
        }
        try {
            return this.enginePermissionsCheck(apiCallContext, apiSession);
        }
        catch (BonitaException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected boolean isAlwaysAuthorizedResource(APICallContext apiCallContext) {
        return apiCallContext.isGET() && (this.isSingleResourceCall(apiCallContext, "session") || this.isSingleResourceCall(apiCallContext, "i18nlocale"));
    }

    private boolean isSingleResourceCall(APICallContext apiCallContext, String authorizedResourceName) {
        return authorizedResourceName.equals(apiCallContext.getResourceName()) && "system".equals(apiCallContext.getApiName());
    }

    protected String getRequestBody(HttpServletRequest request) throws ServletException {
        try {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[Multi-Part Request] not adding body to APIContext");
                }
                return null;
            }
            ServletInputStream inputStream = request.getInputStream();
            return IOUtils.toString((InputStream)inputStream, (String)request.getCharacterEncoding());
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected boolean isApiAuthorizationsCheckEnabled() {
        return PropertiesFactory.getSecurityProperties().isAPIAuthorizationsCheckEnabled();
    }

    protected boolean enginePermissionsCheck(APICallContext apiCallContext, APISession apiSession) throws ServerAPIException, BonitaHomeNotSetException, UnknownAPITypeException, ExecutionException {
        return TenantAPIAccessor.getPermissionAPI((APISession)apiSession).isAuthorized(apiCallContext);
    }

    @Override
    public String getDefaultExcludedPages() {
        return AUTHORIZATION_FILTER_EXCLUDED_PAGES_PATTERN;
    }
}

