/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.utils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.bonitasoft.console.common.server.login.HttpServletRequestAccessor;
import org.bonitasoft.console.common.server.login.utils.RedirectUrlBuilder;

public class RedirectUrlHandler {
    public static boolean shouldRedirectAfterLogin(HttpServletRequest request) {
        String redirectAfterLogin = request.getParameter("redirect");
        String redirectURL = request.getParameter("redirectUrl");
        return redirectAfterLogin != null ? Boolean.parseBoolean(redirectAfterLogin) : redirectURL != null;
    }

    public static boolean shouldRedirectAfterLogout(HttpServletRequest request) {
        String redirectAfterLogin = request.getParameter("redirect");
        String redirectURL = request.getParameter("redirectUrl");
        String loginPageURL = request.getParameter("loginUrl");
        return redirectAfterLogin != null ? Boolean.parseBoolean(redirectAfterLogin) : redirectURL != null || loginPageURL != null;
    }

    public static String retrieveRedirectUrl(HttpServletRequestAccessor request, String ... parametersToRemove) throws ServletException {
        String redirectUrlFromRequest = request.getRedirectUrl();
        String redirectUrl = redirectUrlFromRequest != null ? redirectUrlFromRequest : RedirectUrlHandler.getDefaultRedirectUrl();
        RedirectUrlBuilder redirectUrlBuilder = new RedirectUrlBuilder(redirectUrl);
        for (String parameterToRemove : parametersToRemove) {
            redirectUrlBuilder.removeParameter(parameterToRemove);
        }
        return redirectUrlBuilder.build().getUrl();
    }

    protected static String getDefaultRedirectUrl() {
        return "apps/appDirectoryBonita";
    }
}

