/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.page;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.engine.exception.BonitaException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ResourceRenderer.class.getName());

    public void renderFile(HttpServletRequest request, HttpServletResponse response, File resourceFile) throws CompilationFailedException, IllegalAccessException, IOException, BonitaException {
        this.renderFile(request, response, resourceFile, false);
    }

    public void renderFile(HttpServletRequest request, HttpServletResponse response, File resourceFile, boolean isPage) throws CompilationFailedException, IllegalAccessException, IOException, BonitaException {
        response.setCharacterEncoding("UTF-8");
        try {
            byte[] content = this.getFileContent(resourceFile);
            response.setContentType(request.getSession().getServletContext().getMimeType(resourceFile.getName()));
            response.setContentLength(content.length);
            response.setBufferSize(content.length);
            ServletOutputStream out = response.getOutputStream();
            out.write(content, 0, content.length);
        }
        catch (FileNotFoundException e) {
            if (isPage) {
                response.sendError(404, e.getMessage());
            } else {
                response.setStatus(404);
            }
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Error while generating the response.", (Throwable)e);
            }
            throw e;
        }
    }

    private byte[] getFileContent(File resourceFile) throws IOException, BonitaException {
        if (resourceFile == null) {
            String errorMessage = "Resource file must not be null.";
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Resource file must not be null.");
            }
            throw new BonitaException("Resource file must not be null.");
        }
        if (resourceFile.exists()) {
            return Files.readAllBytes(resourceFile.toPath());
        }
        String fileNotFoundMessage = "Cannot find the resource file ";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cannot find the resource file " + resourceFile.getCanonicalPath());
        }
        throw new FileNotFoundException("Cannot find the resource file " + resourceFile.getName());
    }

    public List<String> getPathSegments(String pathInfo) throws UnsupportedEncodingException {
        ArrayList<String> segments = new ArrayList<String>();
        if (pathInfo != null) {
            for (String segment : pathInfo.split("/")) {
                if (segment.isEmpty()) continue;
                segments.add(URLDecoder.decode(segment, StandardCharsets.UTF_8));
            }
        }
        return segments;
    }
}

