/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.preferences.properties;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstantsUtils;
import org.bonitasoft.console.common.server.utils.PlatformManagementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFilesManager {
    private static final ConfigurationFilesManager INSTANCE = new ConfigurationFilesManager();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConfigurationFilesManager.class.getName());
    private final Map<String, Properties> tenantConfigurations = new HashMap<String, Properties>();
    private final Map<String, File> tenantConfigurationFiles = new HashMap<String, File>();
    private Map<String, Properties> platformConfigurations = new HashMap<String, Properties>();
    private final Map<String, File> platformConfigurationFiles = new HashMap<String, File>();

    public static ConfigurationFilesManager getInstance() {
        return INSTANCE;
    }

    public Properties getPlatformProperties(String propertiesFile) {
        Properties properties = this.platformConfigurations.get(propertiesFile);
        if (properties == null) {
            return new Properties();
        }
        return properties;
    }

    Properties getAlsoCustomAndInternalPropertiesFromFilename(String propertiesFileName) {
        Properties properties = new Properties();
        Properties tenantConfiguration = this.getTenantConfiguration(propertiesFileName);
        if (tenantConfiguration != null) {
            String customPropertyFilename;
            Properties customConfiguration;
            properties.putAll((Map<?, ?>)tenantConfiguration);
            String internalPropertyFilename = this.getSuffixedPropertyFilename(propertiesFileName, "-internal");
            Properties internalConfiguration = this.getTenantConfiguration(internalPropertyFilename);
            if (internalConfiguration != null) {
                properties.putAll((Map<?, ?>)internalConfiguration);
            }
            if ((customConfiguration = this.getTenantConfiguration(customPropertyFilename = this.getSuffixedPropertyFilename(propertiesFileName, "-custom"))) != null) {
                properties.putAll((Map<?, ?>)customConfiguration);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("File " + propertiesFileName + " not found. Returning empty properties object.");
        }
        return properties;
    }

    public Properties getTenantProperties(String propertiesFileName) {
        return this.getAlsoCustomAndInternalPropertiesFromFilename(propertiesFileName);
    }

    public static Properties getProperties(byte[] content) {
        Properties properties = new Properties();
        if (content != null) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(content);){
                properties.load(inputStream);
            }
            catch (IOException ioe) {
                LOGGER.error("Cannot parse properties file content", (Throwable)ioe);
            }
        }
        return properties;
    }

    public void setPlatformConfigurations(Map<String, byte[]> configurationFiles) throws IOException {
        this.platformConfigurations = new HashMap<String, Properties>(configurationFiles.size());
        for (Map.Entry<String, byte[]> entry : configurationFiles.entrySet()) {
            if (entry.getKey().endsWith(".properties")) {
                this.platformConfigurations.put(entry.getKey(), ConfigurationFilesManager.getProperties(entry.getValue()));
                continue;
            }
            File file = new File(WebBonitaConstantsUtils.getPlatformInstance().getTempFolder(), entry.getKey());
            FileUtils.writeByteArrayToFile((File)file, (byte[])entry.getValue());
            this.platformConfigurationFiles.put(entry.getKey(), file);
        }
    }

    public synchronized void setTenantConfigurationFiles(Map<String, byte[]> configurationFiles) throws IOException {
        for (Map.Entry<String, byte[]> entry : configurationFiles.entrySet()) {
            if (!entry.getKey().endsWith(".properties")) {
                File file = new File(WebBonitaConstantsUtils.getTenantInstance().getTempFolder(), entry.getKey());
                FileUtils.writeByteArrayToFile((File)file, (byte[])entry.getValue());
                this.tenantConfigurationFiles.put(entry.getKey(), file);
            }
            this.tenantConfigurations.put(entry.getKey(), ConfigurationFilesManager.getProperties(entry.getValue()));
        }
    }

    private String getSuffixedPropertyFilename(String propertiesFilename, String suffix) {
        return propertiesFilename.replaceAll("\\.properties$", suffix + ".properties");
    }

    PlatformManagementUtils getPlatformManagementUtils() {
        return new PlatformManagementUtils();
    }

    public File getTenantConfigurationFile(String fileName) {
        if (this.tenantConfigurationFiles.isEmpty()) {
            try {
                this.setTenantConfigurationFiles(this.getPlatformManagementUtils().readTenantConfigurationsFromEngine());
            }
            catch (IOException e) {
                LOGGER.error("Cannot retrieve tenant configuration files", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.tenantConfigurationFiles.get(fileName);
    }

    Properties getTenantConfiguration(String propertiesFilename) {
        if (this.tenantConfigurations.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Tenant configuration file {} not yet in cache. Adding it.", (Object)propertiesFilename);
            }
            try {
                this.setTenantConfigurationFiles(this.getPlatformManagementUtils().readTenantConfigurationsFromEngine());
            }
            catch (IOException e) {
                LOGGER.error("Cannot retrieve tenant configuration", (Throwable)e);
                throw new RuntimeException(e);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Retrieving tenant configuration file {} from cache.", (Object)propertiesFilename);
        }
        return this.tenantConfigurations.get(propertiesFilename);
    }

    public File getPlatformConfigurationFile(String fileName) {
        return this.platformConfigurationFiles.get(fileName);
    }
}

