/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.utils;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.console.common.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleUtils {
    public static final String LOCALE_PARAM = "locale";
    public static final String PORTAL_LOCALE_PARAM = "_l";
    public static final String DEFAULT_LOCALE = "en";
    public static final String LOCALE_COOKIE_NAME = "BOS_Locale";
    private static final String DEFAULT_APPLICATION = "portal";
    private static final Map<String, String> AVAILABLE_LOCALES = I18n.getInstance().getAvailableLocalesFor("portal");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)LocaleUtils.class.getName());

    public static String getUserLocaleAsString(HttpServletRequest request) {
        String locale = LocaleUtils.getLocaleFromRequestURL(request);
        if (locale == null) {
            locale = LocaleUtils.getStandardizedLocaleFromCookie(request);
        }
        if (locale == null) {
            String browserLocale = LocaleUtils.getLocaleFromBrowser(request);
            locale = browserLocale != null ? browserLocale : DEFAULT_LOCALE;
        }
        return locale;
    }

    public static void logUnsupportedLocale(String unsupportedLocale, String usedLocale) {
        if (!unsupportedLocale.equals(usedLocale) && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Locale \"" + unsupportedLocale + "\" is not part of the locales available. Using locale \"" + usedLocale + "\"");
        }
    }

    public static boolean isLocaleSupportedInPortal(String locale) {
        return new ArrayList<String>(AVAILABLE_LOCALES.keySet()).contains(locale);
    }

    public static boolean canLocaleBeReducedToSupportedLocale(String locale, String supportedLocale) {
        if (locale.indexOf("-") > 0) {
            return locale.substring(0, locale.indexOf("-")).equals(supportedLocale);
        }
        if (locale.indexOf("_") > 0) {
            return locale.substring(0, locale.indexOf("_")).equals(supportedLocale);
        }
        return false;
    }

    private static String standardizeLocale(String locale) {
        if (LocaleUtils.isLocaleSupportedInPortal(locale)) {
            return locale;
        }
        ArrayList<String> supportedLocales = new ArrayList<String>(AVAILABLE_LOCALES.keySet());
        for (String supportedLocale : supportedLocales) {
            if (!LocaleUtils.canLocaleBeReducedToSupportedLocale(locale, supportedLocale)) continue;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Using available locale \"" + supportedLocale + "\" instead of \"" + locale + "\"");
            }
            return supportedLocale;
        }
        LocaleUtils.logUnsupportedLocale(locale, DEFAULT_LOCALE);
        return DEFAULT_LOCALE;
    }

    public static String getStandardizedLocaleFromCookie(HttpServletRequest request) {
        String locale = LocaleUtils.getLocaleFromCookies(request);
        return locale != null ? LocaleUtils.standardizeLocale(locale) : null;
    }

    public static String getLocaleFromCookies(HttpServletRequest request) {
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!cookie.getName().equals(LOCALE_COOKIE_NAME)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static String getLocaleFromBrowser(HttpServletRequest request) {
        Locale browserLocale = request.getLocale();
        return browserLocale != null ? LocaleUtils.standardizeLocale(browserLocale.toString()) : null;
    }

    public static Locale getUserLocale(HttpServletRequest request) {
        return org.apache.commons.lang3.LocaleUtils.toLocale((String)LocaleUtils.getUserLocaleAsString(request));
    }

    public static String getLocaleFromRequestURL(HttpServletRequest request) {
        String localeAsString = request.getParameter(LOCALE_PARAM);
        if (localeAsString == null) {
            localeAsString = request.getParameter(PORTAL_LOCALE_PARAM);
        }
        if (localeAsString != null && localeAsString.length() > 0) {
            try {
                org.apache.commons.lang3.LocaleUtils.toLocale((String)localeAsString);
                localeAsString = LocaleUtils.standardizeLocale(localeAsString);
            }
            catch (Exception e) {
                LocaleUtils.logUnsupportedLocale(localeAsString, DEFAULT_LOCALE);
                localeAsString = DEFAULT_LOCALE;
            }
            return localeAsString;
        }
        return null;
    }

    public static void addOrReplaceLocaleCookieResponse(HttpServletResponse response, String locale) {
        String standardizedLocale = LocaleUtils.standardizeLocale(locale);
        Cookie localeCookie = new Cookie(LOCALE_COOKIE_NAME, standardizedLocale);
        localeCookie.setPath("/");
        response.addCookie(localeCookie);
    }
}

