/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.server.service;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.server.service.ConsoleService;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ExecutionException;
import org.bonitasoft.engine.exception.ImportException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.io.FileContent;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.web.common.model.ImportStatusMessages;
import org.bonitasoft.web.rest.server.framework.json.JacksonSerializer;
import org.bonitasoft.web.toolkit.client.common.i18n.AbstractI18n;
import org.bonitasoft.web.toolkit.server.ServiceException;
import org.slf4j.Logger;

abstract class BonitaImportService
extends ConsoleService {
    public static final String IMPORT_POLICY_PARAM_NAME = "importPolicy";

    BonitaImportService() {
    }

    @Override
    public Object run() {
        FileContent xmlFile;
        try {
            xmlFile = this.getTenantFolder().retrieveUploadedTempContent(this.getFileUploadParamValue());
        }
        catch (BonitaException e) {
            throw new ServiceException(this.getToken(), e.getMessage(), e);
        }
        String importPolicyAsString = this.getParameter(IMPORT_POLICY_PARAM_NAME);
        try {
            JacksonSerializer serializer = new JacksonSerializer();
            ImportStatusMessages importStatusMessages = this.importFileContent(this.readImportFile(xmlFile.getInputStream()), importPolicyAsString);
            String string = serializer.serialize(importStatusMessages);
            return string;
        }
        catch (InvalidSessionException e) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info(AbstractI18n.t_("Session expired. Please log in again."), (Throwable)e);
            }
            throw e;
        }
        catch (ExecutionException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(e.getMessage(), (Throwable)e);
            }
            throw new ServiceException(this.getToken(), this.getFileFormatExceptionMessage(), e);
        }
        catch (ImportException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(e.getMessage(), (Throwable)e);
            }
            throw new ServiceException(this.getToken(), this.getFileFormatExceptionMessage(), e);
        }
        catch (AlreadyExistsException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(e.getMessage(), (Throwable)e);
            }
            throw new ServiceException(this.getToken(), this.getAlreadyExistsExceptionMessage(e), e);
        }
        catch (Exception e) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            throw new ServiceException(this.getToken(), e);
        }
        finally {
            this.getTenantFolder().removeUploadedTempContent(this.getFileUploadParamValue());
        }
    }

    protected byte[] readImportFile(InputStream xmlInputStream) {
        byte[] byArray;
        block8: {
            InputStream inputStream = xmlInputStream;
            try {
                byArray = IOUtils.toByteArray((InputStream)xmlInputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ServiceException(this.getFileReadingError(), e);
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    protected BonitaHomeFolderAccessor getTenantFolder() {
        return new BonitaHomeFolderAccessor();
    }

    protected String getFileUploadParamValue() {
        return this.getParameter(this.getFileUploadParamName());
    }

    protected abstract String getFileReadingError();

    protected abstract String getToken();

    protected abstract String getFileUploadParamName();

    protected abstract ImportStatusMessages importFileContent(byte[] var1, String var2) throws ExecutionException, ImportException, AlreadyExistsException, InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException;

    protected abstract String getFileFormatExceptionMessage();

    protected abstract String getAlreadyExistsExceptionMessage(AlreadyExistsException var1);

    protected abstract Logger getLogger();
}

