/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.livingapps;

import java.io.Serializable;
import java.util.Optional;
import org.bonitasoft.engine.api.ApplicationAPI;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.api.ProfileAPI;
import org.bonitasoft.engine.business.application.Application;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.livingapps.ApplicationModel;
import org.bonitasoft.livingapps.exception.CreationException;
import org.bonitasoft.livingapps.menu.MenuFactory;

public class ApplicationModelFactory {
    private final ApplicationAPI applicationApi;
    private final PageAPI customPageApi;
    private final ProfileAPI profileApi;

    public ApplicationModelFactory(ApplicationAPI applicationApi, PageAPI customPageApi, ProfileAPI profileApi) {
        this.applicationApi = applicationApi;
        this.customPageApi = customPageApi;
        this.profileApi = profileApi;
    }

    public ApplicationModel createApplicationModel(String name) throws CreationException {
        try {
            SearchResult result = this.applicationApi.searchIApplications(new SearchOptionsBuilder(0, 1).filter("token", (Serializable)((Object)name)).done());
            if (result.getCount() == 0L) {
                throw new CreationException("No application found with name " + name);
            }
            Optional<Application> legacyApplication = result.getResult().stream().filter(Application.class::isInstance).map(Application.class::cast).findFirst();
            if (legacyApplication.isEmpty()) {
                throw new CreationException("Only application links were found with name " + name);
            }
            return new ApplicationModel(this.applicationApi, this.customPageApi, this.profileApi, legacyApplication.get(), new MenuFactory(this.applicationApi));
        }
        catch (SearchException e) {
            throw new CreationException("Error while searching for the application " + name, e);
        }
    }
}

