/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.model.application;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.bonitasoft.web.rest.model.application.AbstractApplicationItem;
import org.bonitasoft.web.rest.model.application.ApplicationDefinition;
import org.bonitasoft.web.rest.model.application.ApplicationLinkDefinition;
import org.bonitasoft.web.toolkit.client.common.AbstractTreeNode;
import org.bonitasoft.web.toolkit.client.common.TreeIndexed;
import org.bonitasoft.web.toolkit.client.common.TreeLeaf;
import org.bonitasoft.web.toolkit.client.data.item.Definitions;
import org.bonitasoft.web.toolkit.client.data.item.DiscriminatedItemDefinitionHelper;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ItemAttribute;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ValidationError;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ValidationException;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.FileIsImageOrServletPathValidator;

public class AbstractApplicationDefinition<ITEM extends AbstractApplicationItem>
extends ItemDefinition<ITEM> {
    public static final String TOKEN = "abstractApplication";

    @Override
    protected String defineToken() {
        return TOKEN;
    }

    @Override
    protected String defineAPIUrl() {
        return "../API/living/application";
    }

    @Override
    protected void defineAttributes() {
        this.createAttribute("id", ItemAttribute.TYPE.ITEM_ID);
        this.createAttribute("link", ItemAttribute.TYPE.BOOLEAN);
        this.createAttribute("token", ItemAttribute.TYPE.STRING);
        this.createAttribute("displayName", ItemAttribute.TYPE.STRING);
        this.createAttribute("profileId", ItemAttribute.TYPE.ITEM_ID);
        this.createAttribute("version", ItemAttribute.TYPE.STRING);
        this.createAttribute("description", ItemAttribute.TYPE.TEXT);
        this.createAttribute("icon", ItemAttribute.TYPE.STRING).addValidator(new FileIsImageOrServletPathValidator("../API/applicationIcon/"));
        this.createAttribute("creationDate", ItemAttribute.TYPE.STRING);
        this.createAttribute("createdBy", ItemAttribute.TYPE.ITEM_ID);
        this.createAttribute("lastUpdateDate", ItemAttribute.TYPE.STRING);
        this.createAttribute("updatedBy", ItemAttribute.TYPE.ITEM_ID);
        this.createAttribute("state", ItemAttribute.TYPE.STRING);
        this.createAttribute("visibility", ItemAttribute.TYPE.STRING);
        this.createAttribute("editable", ItemAttribute.TYPE.BOOLEAN);
    }

    @Override
    protected void definePrimaryKeys() {
        this.setPrimaryKeys("id");
    }

    public static AbstractApplicationDefinition<? extends AbstractApplicationItem> get() {
        return (AbstractApplicationDefinition)Definitions.get(TOKEN);
    }

    @Override
    protected ITEM _createItem() {
        throw new ValidationException(Collections.singletonList(new ValidationError("link", "%attribute% is mandatory to discriminate the application type")));
    }

    @Override
    public Optional<DiscriminatedItemDefinitionHelper<ITEM>> getDiscriminatedHelper() {
        if (AbstractApplicationDefinition.class.equals(this.getClass())) {
            return Optional.of(new DiscriminatedItemDefinitionHelper<ITEM>(){

                @Override
                public Supplier<ITEM> findItemCreator(Map<String, String> attributes) {
                    boolean isLink = attributes != null && Boolean.parseBoolean(attributes.get("link"));
                    return isLink ? () -> ApplicationLinkDefinition.get()._createItem() : () -> ApplicationDefinition.get()._createItem();
                }

                @Override
                public Supplier<? extends ITEM> findItemCreator(TreeIndexed<String> tree) {
                    boolean isLink;
                    AbstractTreeNode<String> abstractTreeNode;
                    if (tree != null && (abstractTreeNode = tree.get("link")) instanceof TreeLeaf) {
                        TreeLeaf v = (TreeLeaf)abstractTreeNode;
                        isLink = Optional.ofNullable(v.getValue()).map(Object::toString).map(Boolean::parseBoolean).orElse(Boolean.FALSE);
                    } else {
                        isLink = false;
                    }
                    return isLink ? () -> ApplicationLinkDefinition.get()._createItem() : () -> ApplicationDefinition.get()._createItem();
                }
            });
        }
        return Optional.empty();
    }
}

