/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.flownode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.rest.model.bpm.cases.ArchivedCaseItem;
import org.bonitasoft.web.rest.model.bpm.cases.CaseItem;
import org.bonitasoft.web.rest.model.bpm.flownode.FlowNodeDefinition;
import org.bonitasoft.web.rest.model.bpm.flownode.IFlowNodeItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.api.deployer.GenericDeployer;
import org.bonitasoft.web.rest.server.datastore.bpm.cases.ArchivedCaseDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.cases.CaseDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.FlowNodeDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.TaskDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.TaskFinder;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.archive.ArchivedTaskDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.process.ActorDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.process.ProcessDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.UserDatastore;
import org.bonitasoft.web.rest.server.framework.api.APIHasGet;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.api.APIHasUpdate;
import org.bonitasoft.web.rest.server.framework.api.Datastore;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.IItem;

public class AbstractAPIFlowNode<ITEM extends IFlowNodeItem>
extends ConsoleAPI<ITEM>
implements APIHasUpdate<ITEM>,
APIHasGet<ITEM>,
APIHasSearch<ITEM> {
    protected FlowNodeDefinition defineItemDefinition() {
        return FlowNodeDefinition.get();
    }

    @Override
    public String defineDefaultSearchOrder() {
        return "displayName ASC";
    }

    @Override
    protected Datastore defineDefaultDatastore() {
        return new FlowNodeDatastore(this.getEngineSession());
    }

    @Override
    public ItemSearchResult<ITEM> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        if (filters.containsKey("team_manager_id") && filters.containsKey("supervisor_id")) {
            throw new APIException("Can't set those filters at the same time : team_manager_id and supervisor_id");
        }
        return super.search(page, resultsByPage, search, orders, filters);
    }

    @Override
    public ITEM update(APIID id, Map<String, String> attributes) {
        String state = attributes.get("state");
        if (state != null && !this.isAllowedState(state)) {
            throw new APIException("Can't update a flow node state to \"" + state + "\"");
        }
        return (ITEM)((IFlowNodeItem)super.update(id, attributes));
    }

    protected boolean isAllowedState(String state) {
        return "ready".equals(state) || "skipped".equals(state) || "replay".equals(state) || "completed".equals(state);
    }

    @Override
    protected void fillDeploys(ITEM item, List<String> deploys) {
        if (this.isDeployable("processId", deploys, (IItem)item)) {
            item.setDeploy("processId", new ProcessDatastore(this.getEngineSession()).get(item.getProcessId()));
        }
        if (this.isDeployable("caseId", deploys, (IItem)item) || this.isDeployable("rootCaseId", deploys, (IItem)item)) {
            CaseItem openedCaseItem = this.getCaseDatastore().get(item.getCaseId());
            if (openedCaseItem != null) {
                item.setDeploy("caseId", openedCaseItem);
                item.setDeploy("rootCaseId", openedCaseItem);
            } else {
                ArchivedCaseItem archivedCaseItem = this.getArchivedCaseDatastore().getUsingSourceObjectId(item.getCaseId());
                item.setDeploy("caseId", archivedCaseItem);
                item.setDeploy("rootCaseId", archivedCaseItem);
            }
        }
        if (this.isDeployable("parentCaseId", deploys, (IItem)item)) {
            CaseItem openedParentCaseItem = this.getCaseDatastore().get(item.getParentCaseId());
            if (openedParentCaseItem != null) {
                item.setDeploy("parentCaseId", openedParentCaseItem);
            } else {
                ArchivedCaseItem archivedParentCaseItem = this.getArchivedCaseDatastore().getUsingSourceObjectId(item.getParentCaseId());
                item.setDeploy("parentCaseId", archivedParentCaseItem);
            }
        }
        if (this.isDeployable("rootContainerId", deploys, (IItem)item)) {
            CaseItem rootContainerCase = this.getCaseDatastore().get(item.getAttributeValueAsAPIID("rootContainerId"));
            if (rootContainerCase == null) {
                rootContainerCase = this.getArchivedCase(item.getAttributeValue("rootContainerId"));
            }
            if (rootContainerCase != null) {
                item.setDeploy("rootContainerId", new ProcessDatastore(this.getEngineSession()).get(rootContainerCase.getProcessId()));
            }
        }
        if (this.isDeployable("executedBy", deploys, (IItem)item)) {
            item.setDeploy("executedBy", new UserDatastore(this.getEngineSession()).get(item.getExecutedByUserId()));
        }
        if (this.isDeployable("executedBySubstitute", deploys, (IItem)item)) {
            item.setDeploy("executedBySubstitute", new UserDatastore(this.getEngineSession()).get(item.getExecutedBySubstituteUserId()));
        }
        if (this.isDeployable("actorId", deploys, (IItem)item)) {
            item.setDeploy("actorId", new ActorDatastore(this.getEngineSession()).get(item.getAttributeValueAsAPIID("actorId")));
        }
        if (this.isDeployable("assigned_id", deploys, (IItem)item)) {
            item.setDeploy("assigned_id", new UserDatastore(this.getEngineSession()).get(item.getAttributeValueAsAPIID("assigned_id")));
        }
        this.addDeployer(new GenericDeployer<IItem>(id -> new TaskFinder(new TaskDatastore(this.getEngineSession()), new ArchivedTaskDatastore(this.getEngineSession(), "archivedtask")).find(id), "parentTaskId"));
        super.fillDeploys(item, deploys);
    }

    protected CaseDatastore getCaseDatastore() {
        return new CaseDatastore(this.getEngineSession());
    }

    private CaseItem getArchivedCase(String id) {
        List<ArchivedCaseItem> result = this.getArchivedCaseDatastore().search(0, 1, null, null, Collections.singletonMap("sourceObjectId", id)).getResults();
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    protected ArchivedCaseDatastore getArchivedCaseDatastore() {
        return new ArchivedCaseDatastore(this.getEngineSession());
    }

    @Override
    protected List<String> defineReadOnlyAttributes() {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("caseId");
        attributes.add("rootCaseId");
        attributes.add("parentCaseId");
        attributes.add("processId");
        attributes.add("description");
        attributes.add("name");
        attributes.add("executedBy");
        attributes.add("type");
        attributes.add("id");
        return attributes;
    }
}

