/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.extension;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.bonitasoft.console.common.server.page.PageMappingService;
import org.bonitasoft.console.common.server.page.RestApiRenderer;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.web.extension.rest.RestApiResponse;
import org.bonitasoft.web.rest.server.api.extension.ResourceExtensionResolver;
import org.restlet.Request;
import org.restlet.data.CharacterSet;
import org.restlet.data.CookieSetting;
import org.restlet.data.Header;
import org.restlet.data.MediaType;
import org.restlet.data.Range;
import org.restlet.data.Status;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.ext.servlet.ServletUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiExtensionResource
extends ServerResource {
    public static final String EMPTY_RESPONSE = "";
    private final RestApiRenderer restApiRenderer;
    private final PageMappingService pageMappingService;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ApiExtensionResource.class.getName());

    public ApiExtensionResource(RestApiRenderer restApiRenderer, PageMappingService pageMappingService) {
        this.restApiRenderer = restApiRenderer;
        this.pageMappingService = pageMappingService;
    }

    public Representation doHandle() {
        StringRepresentation stringRepresentation = new StringRepresentation((CharSequence)EMPTY_RESPONSE);
        try {
            RestApiResponse restApiResponse = this.handleRequest();
            this.fillAllContent(stringRepresentation, restApiResponse);
            return stringRepresentation;
        }
        catch (BonitaException e) {
            LOGGER.error("Failed to handle API Extension call", (Throwable)e);
            this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
            return null;
        }
    }

    private void fillAllContent(StringRepresentation stringRepresentation, RestApiResponse restApiResponse) throws BonitaException {
        if (restApiResponse == null) {
            throw new BonitaException("error: restApiResponse is null");
        }
        stringRepresentation.setCharacterSet(new CharacterSet(restApiResponse.getCharacterSet()));
        stringRepresentation.setMediaType(new MediaType(restApiResponse.getMediaType()));
        this.getResponse().setStatus(new Status(restApiResponse.getHttpStatus()));
        this.fillContent(stringRepresentation, restApiResponse);
        this.fillHeaders(stringRepresentation, restApiResponse);
        this.fillCookies(restApiResponse);
    }

    private void fillCookies(RestApiResponse restApiResponse) {
        for (Cookie cookie : restApiResponse.getAdditionalCookies()) {
            this.getResponse().getCookieSettings().add((Object)new CookieSetting(cookie.getVersion(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure()));
        }
    }

    private void fillHeaders(StringRepresentation representation, RestApiResponse restApiResponse) {
        ArrayList<Header> headers = new ArrayList<Header>();
        for (Map.Entry entry : restApiResponse.getAdditionalHeaders().entrySet()) {
            if ("Content-Range".equals(entry.getKey())) {
                ApiExtensionResource.updateRepresentationRange((String)entry.getValue(), (Representation)representation);
                continue;
            }
            if ("Location".equals(entry.getKey())) {
                this.getResponse().setLocationRef((String)entry.getValue());
                continue;
            }
            Header header = new Header((String)entry.getKey(), (String)entry.getValue());
            this.getResponse().getHeaders().add((Object)header);
            headers.add(header);
        }
        HeaderUtils.extractEntityHeaders(headers, (Representation)representation);
    }

    private static void updateRepresentationRange(String value, Representation representation) {
        if (value != null && !value.isEmpty()) {
            int index = value.indexOf(45);
            int index1 = value.indexOf(47);
            if (index != -1) {
                long pageNumber = index == 0 ? -1L : Long.parseLong(value.substring(0, index));
                long pageSize = Long.parseLong(value.substring(index + 1, index1));
                String strLength = value.substring(index1 + 1);
                long instanceSize = 0L;
                if (!"*".equals(strLength)) {
                    instanceSize = Long.parseLong(strLength);
                }
                representation.setRange(new Range(pageNumber, pageSize - pageNumber + 1L, instanceSize, EMPTY_RESPONSE));
            }
        }
    }

    private void fillContent(StringRepresentation stringRepresentation, RestApiResponse restApiResponse) {
        stringRepresentation.setText(restApiResponse.getResponse() != null ? restApiResponse.getResponse().toString() : null);
    }

    private RestApiResponse handleRequest() throws BonitaException {
        Request request = this.getRequest();
        ResourceExtensionResolver resourceExtensionResolver = new ResourceExtensionResolver(request, this.pageMappingService);
        HttpServletRequest httpServletRequest = ServletUtils.getRequest((Request)request);
        try {
            return this.restApiRenderer.handleRestApiCall(httpServletRequest, resourceExtensionResolver);
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw new BonitaException(e.getMessage(), (Throwable)e);
        }
    }
}

