/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.flownode.archive;

import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.flownode.ArchivedFlowNodeInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedFlowNodeInstanceNotFoundException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.flownode.ArchivedFlowNodeItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.FlowNodeConverter;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.archive.ArchivedFlowNodeFilterCreator;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.archive.converter.ArchivedFlowNodeSearchDescriptorConverter;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public abstract class AbstractArchivedFlowNodeDatastore<CONSOLE_ITEM extends ArchivedFlowNodeItem, ENGINE_ITEM extends ArchivedFlowNodeInstance>
extends CommonDatastore<CONSOLE_ITEM, ENGINE_ITEM>
implements DatastoreHasGet<CONSOLE_ITEM>,
DatastoreHasSearch<CONSOLE_ITEM> {
    protected final String token;

    public AbstractArchivedFlowNodeDatastore(APISession engineSession, String token) {
        super(engineSession);
        this.token = token;
    }

    public static ArchivedFlowNodeItem fillConsoleItem(ArchivedFlowNodeItem result, ArchivedFlowNodeInstance item) {
        result.setId(item.getId());
        result.setName(item.getName());
        result.setDisplayName(item.getDisplayName());
        result.setDescription(item.getDescription());
        result.setDisplayDescription(item.getDisplayDescription());
        result.setExecutedByUserId(item.getExecutedBy());
        result.setRootCaseId(item.getRootContainerId());
        result.setParentCaseId(item.getProcessInstanceId());
        result.setProcessId(item.getProcessDefinitionId());
        result.setState(item.getState());
        result.setType(item.getType().name());
        result.setArchivedDate(item.getArchiveDate());
        result.setSourceObjectId(item.getSourceObjectId());
        result.setRootContainerId(item.getRootContainerId());
        result.setExecutedBySubstituteUserId(item.getExecutedBySubstitute());
        return result;
    }

    protected ProcessAPI getProcessAPI() {
        try {
            return TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    protected CONSOLE_ITEM convertEngineToConsoleItem(ENGINE_ITEM item) {
        ArchivedFlowNodeItem result = FlowNodeConverter.convertEngineToConsoleItem(item);
        return (CONSOLE_ITEM)result;
    }

    @Override
    public CONSOLE_ITEM get(APIID id) {
        ENGINE_ITEM archivedFlowNodeInstance = this.runGet(id);
        return this.convertEngineToConsoleItem(archivedFlowNodeInstance);
    }

    protected ENGINE_ITEM runGet(APIID id) {
        try {
            return (ENGINE_ITEM)this.getProcessAPI().getArchivedFlowNodeInstance(id.toLong().longValue());
        }
        catch (ArchivedFlowNodeInstanceNotFoundException e) {
            throw new APIItemNotFoundException(this.token, id);
        }
    }

    @Override
    public ItemSearchResult<CONSOLE_ITEM> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsCreator creator = this.makeSearchOptionCreator(page, resultsByPage, search, orders, filters);
        SearchResult<ENGINE_ITEM> results = this.runSearch(creator, filters);
        return new ItemSearchResult(page, resultsByPage, results.getCount(), this.convertEngineToConsoleItemsList(results.getResult()));
    }

    protected SearchResult<ENGINE_ITEM> runSearch(SearchOptionsCreator creator, Map<String, String> filters) {
        try {
            SearchResult result = this.getProcessAPI().searchArchivedFlowNodeInstances(creator.create());
            return result;
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    protected SearchOptionsCreator makeSearchOptionCreator(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        return new SearchOptionsCreator(page, resultsByPage, search, new Sorts(orders, this.getSearchDescriptorConverter()), new Filters(filters, new ArchivedFlowNodeFilterCreator(this.getSearchDescriptorConverter())));
    }

    protected ArchivedFlowNodeSearchDescriptorConverter getSearchDescriptorConverter() {
        return new ArchivedFlowNodeSearchDescriptorConverter();
    }
}

