/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.flownode.archive;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.engine.bpm.flownode.ArchivedActivityInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedHumanTaskInstance;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.flownode.ArchivedHumanTaskItem;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.archive.AbstractArchivedTaskDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.archive.ArchivedTaskDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.archive.converter.ArchivedActivitySearchDescriptorConverter;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.archive.converter.ArchivedHumanTaskSearchDescriptorConverter;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;

public abstract class AbstractArchivedHumanTaskDatastore<CONSOLE_ITEM extends ArchivedHumanTaskItem, ENGINE_ITEM extends ArchivedHumanTaskInstance>
extends AbstractArchivedTaskDatastore<CONSOLE_ITEM, ENGINE_ITEM> {
    public AbstractArchivedHumanTaskDatastore(APISession engineSession, String token) {
        super(engineSession, token);
    }

    public static ArchivedHumanTaskItem fillConsoleItem(ArchivedHumanTaskItem result, ArchivedHumanTaskInstance item) {
        ArchivedTaskDatastore.fillConsoleItem(result, (ArchivedActivityInstance)item);
        result.setActorId(APIID.makeAPIID(item.getActorId()));
        result.setAssignedId(APIID.makeAPIID(item.getAssigneeId()));
        result.setAssignedDate(item.getClaimedDate());
        result.setPriority(item.getPriority() != null ? item.getPriority().toString().toLowerCase() : null);
        result.setDueDate(item.getExpectedEndDate());
        return result;
    }

    @Override
    public ItemSearchResult<CONSOLE_ITEM> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        String supervisorIdString = filters.remove("supervisor_id");
        SearchOptionsCreator creator = this.makeSearchOptionCreator(page, resultsByPage, search, orders, filters);
        if (StringUtils.isNotBlank((CharSequence)supervisorIdString)) {
            filters.put("supervisor_id", supervisorIdString);
        }
        SearchResult<ENGINE_ITEM> results = this.runSearch(creator, filters);
        return new ItemSearchResult(page, resultsByPage, results.getCount(), this.convertEngineToConsoleItemsList(results.getResult()));
    }

    @Override
    protected SearchResult<ENGINE_ITEM> runSearch(SearchOptionsCreator creator, Map<String, String> filters) {
        try {
            SearchResult result = !MapUtil.isBlank(filters, "supervisor_id") ? this.getProcessAPI().searchArchivedHumanTasksSupervisedBy(MapUtil.getValueAsLong(filters, "supervisor_id").longValue(), creator.create()) : (!MapUtil.isBlank(filters, "team_manager_id") ? this.getProcessAPI().searchArchivedHumanTasksManagedBy(MapUtil.getValueAsLong(filters, "team_manager_id").longValue(), creator.create()) : this.getProcessAPI().searchArchivedHumanTasks(creator.create()));
            return result;
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    protected ArchivedActivitySearchDescriptorConverter getSearchDescriptorConverter() {
        return new ArchivedHumanTaskSearchDescriptorConverter();
    }
}

