/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.converter;

import java.io.Serializable;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.web.rest.server.datastore.converter.ItemConverter;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.data.item.IItem;

public class ItemSearchResultConverter<I extends IItem, E extends Serializable> {
    private final int page;
    private final SearchResult<E> result;
    private final ItemConverter<I, E> converter;
    private final long total;
    private final int nbResultsByPage;

    public ItemSearchResultConverter(int page, int nbResultsByPage, SearchResult<E> result, ItemConverter<I, E> converter) {
        this(page, nbResultsByPage, result, result.getCount(), converter);
    }

    public ItemSearchResultConverter(int page, int nbResultsByPage, SearchResult<E> result, long total, ItemConverter<I, E> converter) {
        this.page = page;
        this.nbResultsByPage = nbResultsByPage;
        this.result = result;
        this.total = total;
        this.converter = converter;
    }

    public ItemSearchResult<I> toItemSearchResult() {
        return new ItemSearchResult<I>(this.page, this.nbResultsByPage, this.total, this.converter.convert(this.result.getResult()));
    }
}

