/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.page;

import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.web.rest.server.datastore.converter.AttributeConverter;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ItemAttribute;

public class PageSearchDescriptorConverter
implements AttributeConverter {
    private static final Map<String, String> attributeNameMapping = new HashMap<String, String>();
    private static final Map<String, ItemAttribute.TYPE> valueTypeMapping = new HashMap<String, ItemAttribute.TYPE>();

    @Override
    public Map<String, ItemAttribute.TYPE> getValueTypeMapping() {
        return valueTypeMapping;
    }

    private static void createMappings() {
        PageSearchDescriptorConverter.addAttributeConverterItem("id", "id", ItemAttribute.TYPE.STRING);
        PageSearchDescriptorConverter.addAttributeConverterItem("urlToken", "name", ItemAttribute.TYPE.STRING);
        PageSearchDescriptorConverter.addAttributeConverterItem("displayName", "displayName", ItemAttribute.TYPE.STRING);
        PageSearchDescriptorConverter.addAttributeConverterItem("isProvided", "provided", ItemAttribute.TYPE.BOOLEAN);
        PageSearchDescriptorConverter.addAttributeConverterItem("createdBy", "installedBy", ItemAttribute.TYPE.STRING);
        PageSearchDescriptorConverter.addAttributeConverterItem("creationDate", "installationDate", ItemAttribute.TYPE.STRING);
        PageSearchDescriptorConverter.addAttributeConverterItem("lastUpdateDate", "lastModificationDate", ItemAttribute.TYPE.STRING);
        PageSearchDescriptorConverter.addAttributeConverterItem("processDefinitionId", "processDefinitionId", ItemAttribute.TYPE.STRING);
    }

    @Override
    public String convert(String attribute) {
        if ("contentType".equals(attribute)) {
            return MapUtil.getValue(attributeNameMapping, attribute, "");
        }
        return MapUtil.getMandatory(attributeNameMapping, attribute);
    }

    private static void addAttributeConverterItem(String webSearchKey, String engineSearchKey, ItemAttribute.TYPE attributeType) {
        attributeNameMapping.put(webSearchKey, engineSearchKey);
        valueTypeMapping.put(webSearchKey, attributeType);
    }

    static {
        PageSearchDescriptorConverter.createMappings();
    }
}

