/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.profile;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.profile.Profile;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.web.rest.model.portal.profile.ProfileItem;
import org.bonitasoft.web.rest.server.datastore.converter.ItemSearchResultConverter;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.filter.GenericFilterCreator;
import org.bonitasoft.web.rest.server.datastore.profile.ProfileItemConverter;
import org.bonitasoft.web.rest.server.datastore.profile.ProfileSearchDescriptorConverter;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.bonitasoft.web.rest.server.engineclient.ProfileEngineClient;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;

public class SearchProfilesHelper
implements DatastoreHasSearch<ProfileItem> {
    private final ProfileEngineClient profileClient;

    public SearchProfilesHelper(ProfileEngineClient profileClient) {
        this.profileClient = profileClient;
    }

    @Override
    public ItemSearchResult<ProfileItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        if (this.isFilteredBy(filters, "user_id")) {
            return this.searchProfilesForUser(page, filters);
        }
        return this.searchProfiles(page, resultsByPage, search, orders, filters);
    }

    private boolean isFilteredBy(Map<String, String> filters, String filterName) {
        return filters != null && !MapUtil.isBlank(filters, filterName);
    }

    private ItemSearchResult<ProfileItem> searchProfiles(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsCreator options = this.makeSearchOptions(page, resultsByPage, search, orders, filters);
        SearchResult<Profile> searchProfiles = this.profileClient.searchProfiles(options.create());
        return new ItemSearchResultConverter<ProfileItem, Profile>(page, resultsByPage, searchProfiles, new ProfileItemConverter()).toItemSearchResult();
    }

    private ItemSearchResult<ProfileItem> searchProfilesForUser(int page, Map<String, String> filters) {
        long userId = Long.parseLong(filters.get("user_id"));
        List<Profile> profiles = this.profileClient.listProfilesForUser(userId);
        return new ItemSearchResult<ProfileItem>(page, profiles.size(), profiles.size(), new ProfileItemConverter().convert(profiles));
    }

    private SearchOptionsCreator makeSearchOptions(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        return new SearchOptionsCreator(page, resultsByPage, search, new Sorts(orders, new ProfileSearchDescriptorConverter()), new Filters(filters, new GenericFilterCreator(new ProfileSearchDescriptorConverter())));
    }
}

