/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.profile.member;

import org.bonitasoft.engine.profile.ProfileMember;
import org.bonitasoft.web.rest.model.portal.profile.ProfileMemberItem;
import org.bonitasoft.web.rest.server.datastore.profile.member.ProfileMemberItemConverter;
import org.bonitasoft.web.rest.server.engineclient.ProfileMemberEngineClient;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class AddProfileMemberHelper
implements DatastoreHasAdd<ProfileMemberItem> {
    private static final Long UNSET = null;
    private final ProfileMemberEngineClient engineClient;

    public AddProfileMemberHelper(ProfileMemberEngineClient engineClient) {
        this.engineClient = engineClient;
    }

    @Override
    public ProfileMemberItem add(ProfileMemberItem item) {
        ProfileMember addedProfileMember = this.addProfileMember(item.getProfileId(), item.getUserId(), item.getGroupId(), item.getRoleId());
        return new ProfileMemberItemConverter().convert(addedProfileMember);
    }

    private ProfileMember addProfileMember(APIID profileId, APIID userId, APIID groupId, APIID roleId) {
        return this.engineClient.createProfileMember(this.toLong(profileId), this.toLong(userId), this.toLong(groupId), this.toLong(roleId));
    }

    private Long toLong(APIID apiId) {
        if (apiId == null || !apiId.isValidLongID()) {
            return UNSET;
        }
        return apiId.toLong();
    }
}

