/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.engineclient;

import java.util.List;
import org.bonitasoft.engine.api.ProfileAPI;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.profile.Profile;
import org.bonitasoft.engine.profile.ProfileCriterion;
import org.bonitasoft.engine.profile.ProfileNotFoundException;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class ProfileEngineClient {
    private final ProfileAPI profileApi;

    public ProfileEngineClient(ProfileAPI profileApi) {
        this.profileApi = profileApi;
    }

    public Profile getProfile(Long id) {
        try {
            return this.profileApi.getProfile(id.longValue());
        }
        catch (RetrieveException e) {
            throw new APIException(e);
        }
        catch (ProfileNotFoundException e) {
            throw new APIItemNotFoundException("profile", APIID.makeAPIID(id));
        }
    }

    public SearchResult<Profile> searchProfiles(SearchOptions options) {
        try {
            return this.profileApi.searchProfiles(options);
        }
        catch (SearchException e) {
            throw new APIException(e);
        }
    }

    public List<Profile> listProfilesForUser(long userId) {
        try {
            return this.profileApi.getProfilesForUser(userId, 0, Integer.MAX_VALUE, ProfileCriterion.ID_ASC);
        }
        catch (RetrieveException e) {
            throw new APIException(e);
        }
    }
}

