/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.common.exception.api;

import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.http.JsonExceptionSerializer;

public class APIItemException
extends APIException {
    private static final long serialVersionUID = -5137218346282966251L;
    protected final String itemType;

    public APIItemException(String itemType) {
        this.itemType = itemType.toLowerCase();
    }

    public APIItemException(String itemType, String message) {
        super(message);
        this.itemType = itemType.toLowerCase();
    }

    public String getItemType() {
        return this.itemType;
    }

    @Override
    protected JsonExceptionSerializer buildJson() {
        return super.buildJson().appendAttribute("itemtype", this.getItemType());
    }

    @Override
    protected String defaultMessage() {
        return "An unknown error occurred on item " + this.getItemType() + " for API " + this.getApi() + "#" + this.getResource();
    }
}

