/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIIncorrectIdException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemIdMalformedException;
import org.bonitasoft.web.toolkit.client.common.json.JSonSerializer;
import org.bonitasoft.web.toolkit.client.common.json.JsonSerializable;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;
import org.bonitasoft.web.toolkit.client.ui.utils.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIID
implements JsonSerializable {
    private static final String SEPARATOR = "/";
    private final List<String> ids = new ArrayList<String>();
    private ItemDefinition<?> itemDefinition = null;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)APIID.class.getName());

    private APIID(String ... id) {
        this(Arrays.asList(id));
    }

    private APIID(Long ... id) {
        for (Long i : id) {
            this.ids.add(i != null ? String.valueOf(i) : null);
        }
    }

    private APIID(List<String> ids) {
        if (ids.size() == 1 && ids.get(0).contains(SEPARATOR)) {
            this.ids.addAll(Arrays.asList(ids.get(0).split(SEPARATOR)));
        } else {
            this.ids.addAll(ids);
        }
    }

    public void setItemDefinition(ItemDefinition<?> definition) {
        this.itemDefinition = definition;
        int size = this.itemDefinition.getPrimaryKeys().size();
        if (this.ids.size() < size) {
            if (size == 0) {
                throw new APIException(this.itemDefinition.getClass().getName() + " is missing a valid primaryKey");
            }
            if (size == 1) {
                throw new APIException("Wrong APIID format for  [" + this.itemDefinition.getClass().getName() + "]. This APIID must be a single id.");
            }
            throw new APIException("Wrong APIID format for  [" + this.itemDefinition.getClass().getName() + "]. This APIID must be compound of [" + ListUtils.join(this.itemDefinition.getPrimaryKeys(), ",") + "] in this exact order.");
        }
    }

    public static APIID makeAPIID(String ... id) {
        if (id == null) {
            return null;
        }
        return APIID.makeAPIID(Arrays.asList(id));
    }

    public static APIID makeAPIID(Long ... ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        for (Long id : ids) {
            if (id == null || id <= 0L) continue;
            return new APIID(ids);
        }
        return null;
    }

    public static APIID makeAPIID(List<String> ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        for (String id : ids) {
            if (id == null || id.isEmpty()) continue;
            return new APIID(ids);
        }
        return null;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public String toString() {
        Object resourceId = "";
        if (this.ids != null && this.ids.size() > 0) {
            for (String id : this.ids) {
                if (!"".equals(resourceId)) {
                    resourceId = (String)resourceId + SEPARATOR;
                }
                resourceId = (String)resourceId + id;
            }
        }
        return resourceId;
    }

    public boolean isValidLongID() {
        if (this.ids.size() == 1) {
            try {
                long lid = Long.parseLong(this.ids.get(0));
                if (lid > 0L) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.debug(this.ids.get(0) + " is not a valid long ID. ID must be non-zero positive number.");
            }
        } else {
            LOGGER.debug("ID is not a valid long ID. ID must not be multiple.");
        }
        return false;
    }

    public Long toLong() {
        if (this.ids.size() > 1) {
            throw new IllegalArgumentException("Can't convert compound ID to long");
        }
        try {
            long lid = Long.parseLong(this.ids.get(0));
            if (lid > 0L) {
                return lid;
            }
            String errorMessage = lid + " is not a valid long ID. ID must be non-zero positive.";
            LOGGER.debug(errorMessage);
            throw new APIIncorrectIdException(errorMessage);
        }
        catch (NumberFormatException e) {
            throw new APIItemIdMalformedException("APIID", "Can't convert non numeric ID to long");
        }
    }

    public final String getPart(int partIndex) {
        return this.ids.get(partIndex);
    }

    public final Long getPartAsLong(int partIndex) {
        return Long.parseLong(this.getPart(partIndex));
    }

    public String getPart(String attributeName) {
        int index = this.itemDefinition.getPrimaryKeys().indexOf(attributeName);
        if (index == -1) {
            throw new APIException(attributeName + " is an invalid APIID index. This APIID must be made of " + ListUtils.join(this.itemDefinition.getPrimaryKeys(), ", ") + " in this exact order.");
        }
        return this.ids.get(index);
    }

    public Long getPartAsLong(String attributeName) {
        String part = this.getPart(attributeName);
        return part == null ? null : Long.valueOf(part);
    }

    public APIID getPartAsAPIID(String attributeName) {
        return APIID.makeAPIID(this.getPart(attributeName));
    }

    public static List<Long> toLongList(List<APIID> ids) {
        ArrayList<Long> results = new ArrayList<Long>();
        for (APIID id : ids) {
            results.add(id.toLong());
        }
        return results;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    @Override
    public String toJson() {
        return JSonSerializer.serialize(this.ids);
    }
}

