/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.data.item.attribute;

import java.util.List;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ModifiableInput;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ModifiersList;
import org.bonitasoft.web.toolkit.client.data.item.attribute.Validable;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ValidatorsList;
import org.bonitasoft.web.toolkit.client.data.item.attribute.modifier.DefaultValueModifier;
import org.bonitasoft.web.toolkit.client.data.item.attribute.modifier.Modifier;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.FileIsImageValidator;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.FileIsNoScript;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.IsBooleanValidator;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.IsIntegerValidator;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.IsNumericValidator;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.MandatoryValidator;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.StringFormatColorValidator;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.StringFormatEmailValidator;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.StringFormatURLValidator;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.StringMaxLengthValidator;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.StringSingleLineValidator;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.Validator;

public final class ItemAttribute
implements Validable,
ModifiableInput {
    public static final int MAX_LENGTH_COLOR = 7;
    public static final int MAX_LENGTH_STRING = 255;
    public static final int MAX_LENGTH_TEXT = 2000;
    public static final int MAX_LENGTH_URL = 1024;
    private final String name;
    private final TYPE type;
    private final String defaultValue;
    private final ModifiersList inputModifiers = new ModifiersList();
    private final ValidatorsList validators = new ValidatorsList();

    public ItemAttribute(String name, TYPE type) {
        this.defaultValue = null;
        this.name = name;
        this.type = type;
        this.initType();
    }

    private void initType() {
        switch (this.type) {
            case PASSWORD: 
            case STRING: {
                this.addValidator(new StringSingleLineValidator());
                this.addValidator(new StringMaxLengthValidator(255));
                break;
            }
            case IMAGE: {
                this.addValidator(new FileIsImageValidator());
                this.addValidator(new StringMaxLengthValidator(255));
                break;
            }
            case NUMERIC: {
                this.addValidator(new IsNumericValidator());
                break;
            }
            case INTEGER: {
                this.addValidator(new IsIntegerValidator());
                break;
            }
            case TEXT: {
                this.addValidator(new StringMaxLengthValidator(2000));
                break;
            }
            case BOOLEAN: {
                this.addValidator(new IsBooleanValidator());
                break;
            }
            case FILE: {
                this.addValidator(new FileIsNoScript());
                this.addValidator(new StringMaxLengthValidator(255));
                break;
            }
            case ENUM: {
                break;
            }
            case EMAIL: {
                this.addValidator(new StringFormatEmailValidator());
                this.addValidator(new StringMaxLengthValidator(255));
                break;
            }
            case URL: {
                this.addValidator(new StringFormatURLValidator());
                this.addValidator(new StringMaxLengthValidator(1024));
                break;
            }
            case COLOR: {
                this.addValidator(new StringFormatColorValidator());
                this.addValidator(new StringMaxLengthValidator(7));
                break;
            }
            default: {
                this.addValidator(new StringMaxLengthValidator(1024));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public TYPE getType() {
        return this.type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public List<Modifier> getInputModifiers() {
        return this.inputModifiers.getModifiers();
    }

    @Override
    public void addInputModifier(Modifier modifier) {
        this.inputModifiers.addModifier(modifier);
    }

    @Override
    public List<Validator> getValidators() {
        return this.validators.getValidators();
    }

    @Override
    public ItemAttribute addValidator(Validator validator) {
        validator.setAttributeName(this.name);
        this.validators.addValidator(validator);
        return this;
    }

    @Override
    public ItemAttribute addValidators(List<Validator> validators) {
        this.validators.addValidators((List)validators);
        return this;
    }

    @Override
    public ItemAttribute removeValidator(String validatorClassName) {
        this.validators.removeValidator(validatorClassName);
        return this;
    }

    @Override
    public boolean hasValidator(String validatorClassName) {
        return this.validators.hasValidator(validatorClassName);
    }

    @Override
    public Validator getValidator(String validatorClassName) {
        return this.validators.getValidator(validatorClassName);
    }

    public ItemAttribute setDefaultValue(String value) {
        this.addInputModifier(new DefaultValueModifier(value));
        return this;
    }

    public ItemAttribute isMandatory(boolean isMandatory) {
        if (isMandatory) {
            this.addValidator(new MandatoryValidator());
        } else {
            this.removeValidator(MandatoryValidator.class.getName());
        }
        return this;
    }

    public ItemAttribute isMandatory() {
        return this.isMandatory(true);
    }

    public static enum TYPE {
        STRING,
        TEXT,
        IMAGE,
        PASSWORD,
        FILE,
        BOOLEAN,
        ENUM,
        NUMERIC,
        INTEGER,
        DATE,
        TIME,
        DATETIME,
        COLOR,
        EMAIL,
        URL,
        ITEM_ID;

    }
}

