/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.data.item.attribute.validator;

import java.util.regex.Pattern;
import org.bonitasoft.web.toolkit.client.common.i18n.AbstractI18n;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.AbstractStringValidator;

public abstract class AbstractStringFormatValidator
extends AbstractStringValidator {
    private final Pattern regexp;
    private Boolean exclude;

    public AbstractStringFormatValidator(String regexp) {
        this(regexp, false);
    }

    public AbstractStringFormatValidator(String regexp, boolean exclude) {
        this.regexp = Pattern.compile(regexp);
        this.exclude = exclude;
    }

    protected void setExclude(Boolean exclude) {
        this.exclude = exclude;
    }

    @Override
    protected void _check(String attributeValue) {
        boolean match = this.regexp.matcher(attributeValue).find();
        if (attributeValue.contains("HTTP Error")) {
            this.addError(AbstractI18n.t_("Error uploading the file. Maybe your session expired. You can try to refresh the page."));
        } else if (this.exclude.booleanValue() && match || !this.exclude.booleanValue() && !match) {
            this.addError(this.defineErrorMessage());
        }
    }

    protected abstract String defineErrorMessage();
}

