/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIMalformedUrlException;
import org.bonitasoft.web.toolkit.client.common.json.JSonItemReader;
import org.bonitasoft.web.toolkit.client.common.json.JSonSerializer;
import org.bonitasoft.web.toolkit.client.common.json.JsonSerializable;
import org.bonitasoft.web.toolkit.server.Service;
import org.bonitasoft.web.toolkit.server.ServiceFactory;
import org.bonitasoft.web.toolkit.server.ServletCall;

public class ServiceServletCall
extends ServletCall {
    private String calledToolToken;
    private final ServiceFactory serviceFactory;

    public ServiceServletCall(ServiceFactory serviceFactory, HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
        this.serviceFactory = serviceFactory;
    }

    @Override
    protected void parseRequest(HttpServletRequest request, HttpServletResponse response) {
        super.parseRequest(request, response);
        Map<String, String> postParams = JSonItemReader.parseMap(this.getInputStream());
        for (Map.Entry<String, String> entry : postParams.entrySet()) {
            this.parameters.put(entry.getKey(), new String[]{entry.getValue()});
        }
        this.calledToolToken = request.getPathInfo();
        if (this.calledToolToken.length() == 0) {
            throw new APIMalformedUrlException(this.getRequestURL(), "Missing tool name");
        }
    }

    @Override
    public final void doGet() throws IOException {
        this.run();
    }

    @Override
    public final void doPost() throws IOException {
        this.run();
    }

    @Override
    public final void doPut() throws IOException {
        this.run();
    }

    @Override
    public final void doDelete() throws IOException {
        this.run();
    }

    private void run() throws IOException {
        Service service = this.serviceFactory.getService(this.calledToolToken);
        service.setCaller(this);
        Object response = service.run();
        if (response instanceof File) {
            this.output((File)response);
        } else if (response instanceof InputStream) {
            this.output((InputStream)response);
        } else if (response instanceof JsonSerializable || response instanceof Map || response instanceof List) {
            this.output(JSonSerializer.serialize(response));
        } else if (response != null) {
            this.output(response.toString());
        }
    }
}

