/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstantsUtils;

public class MultiReadHttpServletRequest
extends HttpServletRequestWrapper {
    private File tempFile;
    private ByteArrayOutputStream readBytes;
    private boolean isMultipart;

    public MultiReadHttpServletRequest(HttpServletRequest request) {
        super(request);
        this.isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (!this.isMultipart && this.readBytes == null || this.isMultipart && (this.tempFile == null || !this.tempFile.exists())) {
            this.readInputStream();
        }
        return new CachedServletInputStream();
    }

    public BufferedReader getReader() throws IOException {
        String enc = this.getCharacterEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), enc));
    }

    private void readInputStream() throws IOException {
        if (!this.isMultipart) {
            this.readBytes = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)super.getInputStream(), (OutputStream)this.readBytes);
        } else {
            File tempDir = WebBonitaConstantsUtils.getPlatformInstance().getTempFolder();
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            this.tempFile = File.createTempFile("tmp_", ".part", tempDir);
            this.tempFile.deleteOnExit();
            try (FileOutputStream fileOutput = new FileOutputStream(this.tempFile);){
                IOUtils.copy((InputStream)super.getInputStream(), (OutputStream)fileOutput);
            }
        }
    }

    public void cleanMultipartTempContent() {
        if (this.tempFile != null && this.tempFile.exists()) {
            this.tempFile.delete();
        }
        if (this.getRequest() instanceof MultiReadHttpServletRequest) {
            ((MultiReadHttpServletRequest)this.getRequest()).cleanMultipartTempContent();
        }
    }

    class CachedServletInputStream
    extends ServletInputStream {
        private final InputStream input;
        private ReadListener readListener;

        public CachedServletInputStream() throws IOException {
            this.input = !MultiReadHttpServletRequest.this.isMultipart ? new ByteArrayInputStream(MultiReadHttpServletRequest.this.readBytes.toByteArray()) : new FileInputStream(MultiReadHttpServletRequest.this.tempFile);
            this.readListener = null;
        }

        public int read() throws IOException {
            int nextByte = this.input.read();
            if (nextByte == -1) {
                this.onAllDataRead();
            }
            return nextByte;
        }

        public int read(byte[] b) throws IOException {
            int numberOfBytesRead = this.input.read(b);
            if (numberOfBytesRead == -1) {
                this.onAllDataRead();
            }
            return numberOfBytesRead;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int numberOfBytesRead = this.input.read(b, off, len);
            if (numberOfBytesRead == -1) {
                this.onAllDataRead();
            }
            return numberOfBytesRead;
        }

        public void close() throws IOException {
            this.input.close();
            super.close();
        }

        public boolean isFinished() {
            try {
                return this.input.available() == 0;
            }
            catch (IOException e) {
                return true;
            }
        }

        public boolean isReady() {
            return !this.isFinished();
        }

        public void setReadListener(ReadListener readListener) {
            this.readListener = readListener;
            if (!this.isFinished()) {
                try {
                    readListener.onDataAvailable();
                }
                catch (IOException e) {
                    readListener.onError((Throwable)e);
                }
            } else {
                this.onAllDataRead();
            }
        }

        private void onAllDataRead() {
            if (this.readListener != null) {
                try {
                    this.readListener.onAllDataRead();
                }
                catch (IOException e) {
                    this.readListener.onError((Throwable)e);
                }
            }
        }
    }
}

