/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.filter;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.bonitasoft.console.common.server.api.token.APIToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenGenerator {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)TokenGenerator.class.getName());
    public static final String API_TOKEN = "api_token";
    public static final String X_BONITA_API_TOKEN = "X-Bonita-API-Token";

    public String createOrLoadToken(HttpSession session) {
        Object apiTokenFromClient = session.getAttribute(API_TOKEN);
        if (apiTokenFromClient == null) {
            apiTokenFromClient = new APIToken().getToken();
            session.setAttribute(API_TOKEN, apiTokenFromClient);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Bonita API Token generated: " + String.valueOf(apiTokenFromClient));
            }
        }
        return apiTokenFromClient.toString();
    }

    public void setTokenToResponseHeader(HttpServletResponse res, String token) {
        if (res.containsHeader(X_BONITA_API_TOKEN)) {
            res.setHeader(X_BONITA_API_TOKEN, token);
        } else {
            res.addHeader(X_BONITA_API_TOKEN, token);
        }
    }
}

