/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.servlet;

import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.bonitasoft.console.common.server.servlet.IconContent;
import org.bonitasoft.console.common.server.servlet.IconServlet;
import org.bonitasoft.engine.api.APIClient;
import org.bonitasoft.engine.api.ApplicationAPI;
import org.bonitasoft.engine.business.application.Application;
import org.bonitasoft.engine.business.application.ApplicationNotFoundException;
import org.bonitasoft.engine.business.application.ApplicationUpdater;
import org.bonitasoft.engine.business.application.Icon;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.common.exception.http.ServerException;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationIconServlet
extends IconServlet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationIconServlet.class);

    @Override
    protected Optional<IconContent> retrieveIcon(Long iconId, APISession apiSession) {
        ApplicationAPI applicationApi = this.getApplicationApi(apiSession);
        try {
            Icon icon = applicationApi.getIconOfApplication(iconId.longValue());
            if (icon != null) {
                return Optional.of(new IconContent(icon.getContent(), icon.getMimeType()));
            }
            return Optional.empty();
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    @Deprecated(since="9.0.0")
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        log.warn("DELETE request on Application Icon is deprecated! An application icon should be deleted or updated at startup instead.");
        super.doDelete(request, response);
    }

    @Override
    @Deprecated(since="9.0.0")
    protected void deleteIcon(Long entityId, APISession apiSession, HttpServletRequest request) throws ServerException {
        ApplicationAPI applicationApi = this.getApplicationApi(apiSession);
        ApplicationUpdater updater = new ApplicationUpdater();
        updater.setIcon(null, null);
        try {
            applicationApi.updateApplication(entityId.longValue(), updater);
        }
        catch (ApplicationNotFoundException e) {
            throw new APIItemNotFoundException(Application.class.getName(), APIID.makeAPIID(entityId));
        }
        catch (AlreadyExistsException | UpdateException e) {
            throw new APIException(e);
        }
    }

    ApplicationAPI getApplicationApi(APISession apiSession) {
        return new APIClient(apiSession).getApplicationAPI();
    }
}

