/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.common.server.utils.DocumentUtil;
import org.bonitasoft.engine.bpm.contract.ConstraintDefinition;
import org.bonitasoft.engine.bpm.contract.ContractDefinition;
import org.bonitasoft.engine.bpm.contract.FileInputValue;
import org.bonitasoft.engine.bpm.contract.InputDefinition;
import org.bonitasoft.engine.bpm.contract.Type;
import org.bonitasoft.engine.bpm.contract.impl.ContractDefinitionImpl;
import org.bonitasoft.engine.bpm.contract.impl.InputDefinitionImpl;
import org.bonitasoft.engine.bpm.document.DocumentException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.io.FileContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractTypeConverter {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)ContractTypeConverter.class.getName());
    public static final String[] ISO_8601_DATE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"};
    static final String CONTENT_TYPE = "contentType";
    static final String FILE_TEMP_PATH = "tempPath";
    static final String TEMP_PATH_DESCRIPTION = "file name in the temporary upload directory";
    protected BonitaHomeFolderAccessor bonitaHomeFolderAccessor = new BonitaHomeFolderAccessor();
    private final ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
    private long maxSizeForTenant;

    public ContractTypeConverter(String[] datePatterns) {
        this.convertUtilsBean.register(true, false, 0);
        DateConverter dateConverter = new DateConverter();
        dateConverter.setPatterns(datePatterns);
        dateConverter.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.convertUtilsBean.register((Converter)dateConverter, Date.class);
    }

    Object convertToType(Type type, Serializable parameterValue) {
        Class<? extends Serializable> clazz = this.getClassFromType(type);
        Serializable preprocessedParameterValue = this.preprocessInputs(type, parameterValue);
        return this.convertToType(clazz, preprocessedParameterValue);
    }

    private Serializable preprocessInputs(Type type, Serializable parameterValue) {
        if (Type.DATE.equals((Object)type) && parameterValue instanceof Integer) {
            return Long.valueOf(((Integer)parameterValue).intValue());
        }
        return parameterValue;
    }

    public Map<String, Serializable> getProcessedInput(ContractDefinition processContract, Map<String, Serializable> inputs, long maxSizeForTenant) throws FileNotFoundException {
        Map contractDefinitionMap;
        this.maxSizeForTenant = maxSizeForTenant;
        HashMap<String, Serializable> processedInputs = new HashMap<String, Serializable>();
        Map<Object, Object> map = contractDefinitionMap = processContract == null ? Collections.emptyMap() : this.createContractInputMap(processContract.getInputs());
        if (inputs != null) {
            for (Map.Entry<String, Serializable> inputEntry : inputs.entrySet()) {
                processedInputs.put(inputEntry.getKey(), this.convertInputToExpectedType(inputEntry.getValue(), (Serializable)contractDefinitionMap.get(inputEntry.getKey())));
            }
        }
        return processedInputs;
    }

    public void deleteTemporaryFiles(Map<String, Serializable> inputs) {
        if (inputs != null) {
            this.deleteTemporaryFilesInternal((Serializable)((Object)inputs));
        }
    }

    private void deleteTemporaryFilesInternal(Serializable inputValue) {
        block5: {
            block4: {
                if (inputValue == null) {
                    return;
                }
                if (!(inputValue instanceof List)) break block4;
                for (Object element : (List)((Object)inputValue)) {
                    this.deleteTemporaryFilesInternal((Serializable)element);
                }
                break block5;
            }
            if (!(inputValue instanceof Map)) break block5;
            for (Map.Entry element : ((Map)((Object)inputValue)).entrySet()) {
                if (((String)element.getKey()).equals(FILE_TEMP_PATH) && element.getValue() != null) {
                    String path = (String)element.getValue();
                    this.bonitaHomeFolderAccessor.removeUploadedTempContent(path);
                    continue;
                }
                this.deleteTemporaryFilesInternal((Serializable)element.getValue());
            }
        }
    }

    private Serializable convertInputToExpectedType(Serializable inputValue, Serializable inputDefinition) throws FileNotFoundException {
        if (inputValue == null) {
            return null;
        }
        if (inputValue instanceof List) {
            return this.convertMultipleInputToExpectedType(inputValue, inputDefinition);
        }
        return this.convertSingleInputToExpectedType(inputValue, inputDefinition);
    }

    private Serializable convertMultipleInputToExpectedType(Serializable inputValue, Serializable inputDefinition) throws FileNotFoundException {
        List listOfValues = (List)((Object)inputValue);
        ArrayList<Serializable> convertedListOfValues = new ArrayList<Serializable>();
        for (Serializable value : listOfValues) {
            Serializable convertedValue = null;
            if (value != null) {
                convertedValue = this.convertSingleInputToExpectedType(value, inputDefinition);
            }
            convertedListOfValues.add(convertedValue);
        }
        return convertedListOfValues;
    }

    private Serializable convertSingleInputToExpectedType(Serializable inputValue, Serializable inputDefinition) throws FileNotFoundException {
        if (inputDefinition == null) {
            return inputValue;
        }
        if (inputDefinition instanceof Map) {
            Map mapOfInputDefinition = (Map)((Object)inputDefinition);
            return this.convertComplexInputToExpectedType(inputValue, mapOfInputDefinition);
        }
        InputDefinition simpleInputDefinition = (InputDefinition)inputDefinition;
        if (Type.FILE.equals((Object)simpleInputDefinition.getType())) {
            return this.convertFileInputToExpectedType(inputValue);
        }
        return (Serializable)this.convertToType(simpleInputDefinition.getType(), inputValue);
    }

    private Serializable convertComplexInputToExpectedType(Serializable inputValue, Map<String, Serializable> mapOfInputDefinition) throws FileNotFoundException {
        if (inputValue instanceof Map) {
            Map mapOfValues = (Map)((Object)inputValue);
            HashMap<String, Serializable> convertedMapOfValues = new HashMap<String, Serializable>();
            for (Map.Entry valueEntry : mapOfValues.entrySet()) {
                Serializable childInputDefinition = mapOfInputDefinition.get(valueEntry.getKey());
                Serializable convertedValue = this.convertInputToExpectedType((Serializable)valueEntry.getValue(), childInputDefinition);
                convertedMapOfValues.put((String)valueEntry.getKey(), convertedValue);
            }
            return convertedMapOfValues;
        }
        return inputValue;
    }

    private Serializable convertFileInputToExpectedType(Serializable inputValue) throws FileNotFoundException {
        Map mapOfValues;
        if (inputValue instanceof Map && (mapOfValues = (Map)((Object)inputValue)).containsKey("filename") && mapOfValues.containsKey(FILE_TEMP_PATH)) {
            String filename = (String)mapOfValues.get("filename");
            return new FileInputValue(DocumentUtil.sanitizeFilename(filename), (String)mapOfValues.get(CONTENT_TYPE), this.retrieveFileAndGetContent((String)mapOfValues.get(FILE_TEMP_PATH)), (String)mapOfValues.get("id"));
        }
        return inputValue;
    }

    private byte[] retrieveFileAndGetContent(String fileTempPath) throws FileNotFoundException {
        byte[] fileContent = null;
        if (fileTempPath != null) {
            try {
                FileContent sourceFile = this.bonitaHomeFolderAccessor.retrieveUploadedTempContent(fileTempPath);
                try (InputStream inputStream = sourceFile.getInputStream();){
                    fileContent = this.getFileContent(inputStream, sourceFile.getSize());
                }
            }
            catch (BonitaException e) {
                throw new FileNotFoundException("Cannot find " + fileTempPath + " temp file.");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return fileContent;
    }

    private byte[] getFileContent(InputStream inputStream, long size) throws DocumentException, IOException {
        if (size > this.maxSizeForTenant * 0x100000L || size > Integer.MAX_VALUE) {
            String errorMessage = "This document is exceeded configured max size (" + this.maxSizeForTenant + "Mb) or 2GB";
            throw new DocumentException(errorMessage);
        }
        return IOUtils.toByteArray((InputStream)inputStream);
    }

    private Map<String, Serializable> createContractInputMap(List<InputDefinition> inputDefinitions) {
        HashMap<String, Serializable> contractDefinitionMap = new HashMap<String, Serializable>();
        for (InputDefinition inputDefinition : inputDefinitions) {
            if (inputDefinition.hasChildren() && !Type.FILE.equals((Object)inputDefinition.getType())) {
                contractDefinitionMap.put(inputDefinition.getName(), (Serializable)((Object)this.createContractInputMap(inputDefinition.getInputs())));
                continue;
            }
            contractDefinitionMap.put(inputDefinition.getName(), (Serializable)inputDefinition);
        }
        return contractDefinitionMap;
    }

    public ContractDefinition getAdaptedContractDefinition(ContractDefinition contract) {
        if (contract == null) {
            return null;
        }
        List constraints = contract.getConstraints();
        List<InputDefinition> inputDefinitions = this.adaptContractInputList(contract.getInputs());
        return this.getContractDefinition(constraints, inputDefinitions);
    }

    private List<InputDefinition> adaptContractInputList(List<InputDefinition> inputDefinitions) {
        ArrayList<InputDefinition> contractDefinition = new ArrayList<InputDefinition>();
        for (InputDefinition inputDefinition : inputDefinitions) {
            List<InputDefinition> childInputDefinitions = Type.FILE.equals((Object)inputDefinition.getType()) ? this.getFileChildInputDefinitions(inputDefinition) : (inputDefinition.hasChildren() ? this.adaptContractInputList(inputDefinition.getInputs()) : new ArrayList<InputDefinition>());
            InputDefinitionImpl newInputDefinition = new InputDefinitionImpl(inputDefinition.getName(), inputDefinition.getDescription(), inputDefinition.isMultiple(), inputDefinition.getType(), childInputDefinitions);
            contractDefinition.add((InputDefinition)newInputDefinition);
        }
        return contractDefinition;
    }

    private List<InputDefinition> getFileChildInputDefinitions(InputDefinition inputDefinition) {
        ArrayList<InputDefinition> childInputDefinitions = new ArrayList<InputDefinition>();
        for (InputDefinition childInputDefinition : inputDefinition.getInputs()) {
            if (Type.BYTE_ARRAY.equals((Object)childInputDefinition.getType())) {
                childInputDefinitions.add((InputDefinition)new InputDefinitionImpl(FILE_TEMP_PATH, TEMP_PATH_DESCRIPTION, false, Type.TEXT, new ArrayList()));
                continue;
            }
            childInputDefinitions.add(childInputDefinition);
        }
        return childInputDefinitions;
    }

    private ContractDefinitionImpl getContractDefinition(List<ConstraintDefinition> constraints, List<InputDefinition> inputDefinitions) {
        ContractDefinitionImpl contractDefinition = new ContractDefinitionImpl();
        for (ConstraintDefinition constraint : constraints) {
            contractDefinition.addConstraint(constraint);
        }
        for (InputDefinition input : inputDefinitions) {
            contractDefinition.addInput(input);
        }
        return contractDefinition;
    }

    private Object convertToType(Class<? extends Serializable> clazz, Serializable parameterValue) {
        if (parameterValue == null) {
            return null;
        }
        String paramValueString = parameterValue.toString();
        try {
            if (clazz == LocalDate.class) {
                if (paramValueString.length() > 10) {
                    LOGGER.debug("The string " + paramValueString + " contains information that will be dropped to convert it to a LocalDate (most likely time and timezone information which are not relevant).");
                    paramValueString = paramValueString.substring(0, 10);
                }
                return LocalDate.parse(paramValueString);
            }
            if (clazz == LocalDateTime.class) {
                try {
                    return LocalDateTime.parse(paramValueString);
                }
                catch (DateTimeParseException e) {
                    LOGGER.debug("The string " + paramValueString + " contains information that will be dropped to convert it to a LocalDateTime (most likely time and timezone information which are not relevant).");
                    return ZonedDateTime.parse(paramValueString).toLocalDateTime();
                }
            }
            if (clazz == OffsetDateTime.class) {
                ZonedDateTime zonedDateTime = ZonedDateTime.parse(paramValueString);
                return zonedDateTime.toOffsetDateTime();
            }
            return this.convertUtilsBean.convert((Object)parameterValue, clazz);
        }
        catch (DateTimeParseException | ConversionException e) {
            LOGGER.info("unable to parse '" + String.valueOf(parameterValue) + "' to type " + clazz.getName(), e);
            return parameterValue;
        }
    }

    private Class<? extends Serializable> getClassFromType(Type type) {
        switch (type) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case DATE: {
                return Date.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case DECIMAL: {
                return Double.class;
            }
            case BYTE_ARRAY: {
                return Byte[].class;
            }
            case LONG: {
                return Long.class;
            }
            case LOCALDATE: {
                return LocalDate.class;
            }
            case LOCALDATETIME: {
                return LocalDateTime.class;
            }
            case OFFSETDATETIME: {
                return OffsetDateTime.class;
            }
        }
        return String.class;
    }
}

