/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.livingapps;

import java.io.Serializable;
import java.util.List;
import org.bonitasoft.engine.api.ApplicationAPI;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.api.ProfileAPI;
import org.bonitasoft.engine.business.application.Application;
import org.bonitasoft.engine.business.application.ApplicationPageNotFoundException;
import org.bonitasoft.engine.business.application.ApplicationVisibility;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.page.Page;
import org.bonitasoft.engine.page.PageNotFoundException;
import org.bonitasoft.engine.profile.Profile;
import org.bonitasoft.engine.profile.ProfileCriterion;
import org.bonitasoft.engine.search.Order;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.livingapps.menu.Menu;
import org.bonitasoft.livingapps.menu.MenuFactory;

public class ApplicationModel {
    private final ProfileAPI profileApi;
    private final ApplicationAPI applicationApi;
    private final PageAPI pageApi;
    private final Application application;
    private final MenuFactory factory;

    public ApplicationModel(ApplicationAPI applicationApi, PageAPI pageApi, ProfileAPI profileApi, Application application, MenuFactory factory) {
        this.applicationApi = applicationApi;
        this.pageApi = pageApi;
        this.profileApi = profileApi;
        this.application = application;
        this.factory = factory;
    }

    public long getId() {
        return this.application.getId();
    }

    public String getApplicationLayoutName() throws PageNotFoundException {
        return this.pageApi.getPage(this.application.getLayoutId().longValue()).getName();
    }

    public String getApplicationThemeName() throws PageNotFoundException {
        return this.pageApi.getPage(this.application.getThemeId().longValue()).getName();
    }

    public Long getApplicationThemeId() throws PageNotFoundException {
        return this.pageApi.getPage(this.application.getThemeId().longValue()).getId();
    }

    public String getApplicationHomePage() throws ApplicationPageNotFoundException {
        return this.applicationApi.getApplicationHomePage(this.application.getId()).getToken() + "/";
    }

    public boolean hasPage(String pageToken) {
        try {
            this.applicationApi.getApplicationPage(this.application.getToken(), pageToken);
            return true;
        }
        catch (ApplicationPageNotFoundException e) {
            return false;
        }
    }

    public boolean authorize(APISession session) {
        if (ApplicationVisibility.ALL.equals((Object)this.application.getVisibility())) {
            return true;
        }
        if (ApplicationVisibility.TECHNICAL_USER.equals((Object)this.application.getVisibility())) {
            return session.isTechnicalUser();
        }
        for (Profile userProfile : this.getUserProfiles(session)) {
            if (userProfile.getId() != this.application.getProfileId().longValue()) continue;
            return true;
        }
        return false;
    }

    public boolean hasProfileMapped() {
        if (ApplicationVisibility.RESTRICTED.equals((Object)this.application.getVisibility())) {
            return this.application.getProfileId() != null;
        }
        return true;
    }

    private List<Profile> getUserProfiles(APISession session) {
        return this.profileApi.getProfilesForUser(session.getUserId(), 0, Integer.MAX_VALUE, ProfileCriterion.ID_ASC);
    }

    public Page getCustomPage(String pageToken) throws ApplicationPageNotFoundException, PageNotFoundException {
        return this.pageApi.getPage(this.applicationApi.getApplicationPage(this.application.getToken(), pageToken).getPageId());
    }

    public List<Menu> getMenuList() throws SearchException, ApplicationPageNotFoundException {
        return this.factory.create(this.applicationApi.searchApplicationMenus(new SearchOptionsBuilder(0, Integer.MAX_VALUE).filter("applicationId", (Serializable)Long.valueOf(this.application.getId())).sort("index", Order.ASC).done()).getResult());
    }
}

