/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.api.ImportError;
import org.bonitasoft.engine.api.ImportStatus;
import org.bonitasoft.web.common.model.ImportStatusMessage;

public class ImportStatusMessages
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<ImportStatusMessage> errors = new ArrayList<ImportStatusMessage>();
    private final List<ImportStatusMessage> imported = new ArrayList<ImportStatusMessage>();
    private final List<ImportStatusMessage> skipped = new ArrayList<ImportStatusMessage>();

    public ImportStatusMessages(List<ImportStatus> statusMessages) {
        this.setImportStatus(statusMessages);
    }

    public void addResourceImported(ImportStatusMessage profileImportStatusMessage) {
        this.imported.add(profileImportStatusMessage);
    }

    public void addResourceSkipped(ImportStatusMessage profileImportStatusMessage) {
        this.skipped.add(profileImportStatusMessage);
    }

    public void addResourceInError(ImportStatusMessage profileImportStatusMessage) {
        this.errors.add(profileImportStatusMessage);
    }

    public List<ImportStatusMessage> getErrors() {
        return this.errors;
    }

    public List<ImportStatusMessage> getImported() {
        return this.imported;
    }

    public List<ImportStatusMessage> getSkipped() {
        return this.skipped;
    }

    public void setImportStatus(List<ImportStatus> statusMessages) {
        for (ImportStatus statusMessage : statusMessages) {
            if (statusMessage.getErrors().size() > 0) {
                this.addResourceInError(this.convertImportStatus(statusMessage));
                continue;
            }
            if (statusMessage.getStatus().equals((Object)ImportStatus.Status.REPLACED) || statusMessage.getStatus().equals((Object)ImportStatus.Status.ADDED)) {
                this.addResourceImported(this.convertImportStatus(statusMessage));
                continue;
            }
            if (!statusMessage.getStatus().equals((Object)ImportStatus.Status.SKIPPED)) continue;
            this.addResourceSkipped(this.convertImportStatus(statusMessage));
        }
    }

    private ImportStatusMessage convertImportStatus(ImportStatus importStatus) {
        ImportStatusMessage importStatusMessage = new ImportStatusMessage(importStatus.getName(), importStatus.getStatus().toString());
        List errors = importStatus.getErrors();
        for (ImportError error : errors) {
            importStatusMessage.addError(error.getType().toString(), error.getName());
        }
        return importStatusMessage;
    }
}

