/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bdm;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.bonitasoft.engine.bpm.businessdata.BusinessDataQueryMetadata;
import org.bonitasoft.engine.bpm.businessdata.BusinessDataQueryResult;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.web.rest.server.QueryParameterUtils;
import org.bonitasoft.web.rest.server.api.AbstractRESTController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/API/bdm/businessData/{className}"}, produces={"application/json"})
public class BusinessDataController
extends AbstractRESTController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BusinessDataController.class);

    @GetMapping(value={"/{id}"})
    public String getBusinessData(@PathVariable(value="className") String className, @PathVariable(value="id") Long id, HttpSession session) throws BonitaException {
        return this.getBusinessData(className, id, null, session);
    }

    @GetMapping(value={"/{id}/{fieldName}"})
    public String getBusinessData(@PathVariable(value="className") String className, @PathVariable(value="id") Long id, @PathVariable(value="fieldName") String fieldName, HttpSession session) throws BonitaException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("entityClassName", className);
        parameters.put("businessDataId", id);
        parameters.put("businessDataURIPattern", "/API/bdm/businessData/{className}/{id}/{field}");
        if (fieldName != null) {
            parameters.put("businessDataChildName", fieldName);
        }
        return (String)((Object)this.getCommandAPI(session).execute("getBusinessDataById", parameters));
    }

    @GetMapping(value={"/findByIds"})
    public String getBusinessData(@PathVariable(value="className") String className, @RequestParam(value="ids") List<Long> ids, HttpSession session) throws BonitaException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("entityClassName", className);
        parameters.put("businessDataIds", (Serializable)((Object)ids));
        parameters.put("businessDataURIPattern", "/API/bdm/businessData/{className}/{id}/{field}");
        return (String)((Object)this.getCommandAPI(session).execute("getBusinessDataByIds", parameters));
    }

    @GetMapping(value={""})
    public ResponseEntity<String> getBusinessDataByQuery(@PathVariable(value="className") String className, @RequestParam(value="c") Integer searchPageSize, @RequestParam(value="f", required=false) List<String> filters, @RequestParam(value="p") Integer searchPageNumber, @RequestParam(value="q") String queryName, HttpSession session) throws BonitaException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("queryName", queryName);
        parameters.put("queryParameters", (Serializable)((Object)QueryParameterUtils.parseFilters(filters)));
        parameters.put("entityClassName", className);
        parameters.put("startIndex", searchPageNumber * searchPageSize);
        parameters.put("maxResults", searchPageSize);
        parameters.put("businessDataURIPattern", "/API/bdm/businessData/{className}/{id}/{field}");
        if (log.isDebugEnabled()) {
            log.debug("Executing business Data Query: {}", parameters.get("queryName"));
            log.debug("entityClassName: {}", parameters.get("entityClassName"));
            log.debug("queryParameters: {}", (Object)((Serializable)parameters.get("queryParameters")).toString());
            log.debug("startIndex: {}", parameters.get("startIndex"));
            log.debug("maxResults: {}", parameters.get("maxResults"));
        }
        BusinessDataQueryResult businessDataQueryResult = (BusinessDataQueryResult)this.getCommandAPI(session).execute("getBusinessDataByQueryCommand", parameters);
        String json = (String)((Object)businessDataQueryResult.getJsonResults());
        BusinessDataQueryMetadata businessDataQueryMetadata = businessDataQueryResult.getBusinessDataQueryMetadata();
        Long totalCount = null;
        if (businessDataQueryMetadata != null) {
            totalCount = businessDataQueryMetadata.getCount();
        }
        HttpHeaders headers = BusinessDataController.buildHttpHeaders(searchPageSize, searchPageNumber, totalCount);
        return new ResponseEntity((Object)json, (MultiValueMap)headers, HttpStatus.OK);
    }

    private static HttpHeaders buildHttpHeaders(Integer searchPageSize, Integer searchPageNumber, Long totalCount) {
        HttpHeaders headers = new HttpHeaders();
        if (totalCount != null) {
            String contentRangeValue = searchPageNumber + "-" + searchPageSize + "/" + totalCount;
            headers.add("Content-Range", contentRangeValue);
        }
        return headers;
    }
}

