/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.cases;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.data.ArchivedDataInstance;
import org.bonitasoft.web.rest.model.bpm.cases.ArchivedCaseVariable;
import org.bonitasoft.web.rest.server.api.bpm.cases.APICaseVariableAttributeChecker;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;

public class ArchivedCaseVariablesResource
extends CommonResource {
    private final APICaseVariableAttributeChecker attributeChecker = new APICaseVariableAttributeChecker();
    private final ProcessAPI processAPI;
    private List<ArchivedDataInstance> result;
    private int searchPageNumber;
    private int searchPageSize;

    public ArchivedCaseVariablesResource(ProcessAPI processAPI) {
        this.processAPI = processAPI;
    }

    @Get(value="json")
    public List<ArchivedCaseVariable> getArchivedCaseVariables() {
        this.searchPageNumber = this.getSearchPageNumber();
        this.searchPageSize = this.getSearchPageSize();
        Map<String, String> searchFilters = this.getSearchFilters();
        this.attributeChecker.checkSearchFilters(searchFilters);
        long caseId = Long.parseLong(searchFilters.get("case_id"));
        this.result = this.processAPI.getArchivedProcessDataInstances(caseId, 0, Integer.MAX_VALUE);
        return this.result.stream().skip((long)this.searchPageNumber * (long)this.searchPageSize).limit(this.searchPageSize).map(ArchivedCaseVariable::create).collect(Collectors.toList());
    }

    public Representation handle() {
        Representation representation = super.handle();
        this.setContentRange(this.searchPageNumber, this.searchPageSize, this.result.size());
        return representation;
    }
}

