/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.process;

import org.bonitasoft.console.common.server.utils.ContractTypeConverter;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.contract.ContractDefinition;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.restlet.resource.Get;

public class ProcessContractResource
extends CommonResource {
    private static final String PROCESS_DEFINITION_ID = "processDefinitionId";
    private final ProcessAPI processAPI;
    protected final ContractTypeConverter typeConverterUtil = new ContractTypeConverter(ContractTypeConverter.ISO_8601_DATE_PATTERNS);

    public ProcessContractResource(ProcessAPI processAPI) {
        this.processAPI = processAPI;
    }

    @Get(value="json")
    public ContractDefinition getContract() throws ProcessDefinitionNotFoundException {
        ContractDefinition processContract = this.processAPI.getProcessContract(this.getProcessDefinitionIdParameter());
        return this.typeConverterUtil.getAdaptedContractDefinition(processContract);
    }

    protected long getProcessDefinitionIdParameter() {
        String processDefinitionId = this.getAttribute(PROCESS_DEFINITION_ID);
        if (processDefinitionId == null) {
            throw new APIException("Attribute 'processDefinitionId' is mandatory");
        }
        return Long.parseLong(processDefinitionId);
    }
}

