/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.extension;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.console.common.server.page.PageMappingService;
import org.bonitasoft.console.common.server.page.PageReference;
import org.bonitasoft.console.common.server.page.extension.PageResourceProviderImpl;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.server.api.extension.ControllerClassName;
import org.restlet.Request;
import org.restlet.ext.servlet.ServletUtils;

public class ResourceExtensionResolver {
    public static final String MAPPING_KEY_SEPARATOR = "|";
    public static final String MAPPING_KEY_PREFIX = "apiExtension";
    public static final String API_EXTENSION_TEMPLATE_PREFIX = "/API/extension/";
    private final Request request;
    private final PageMappingService pageMappingService;

    public ResourceExtensionResolver(Request request, PageMappingService pageMappingService) {
        this.request = request;
        this.pageMappingService = pageMappingService;
    }

    public Long resolvePageId(APISession apiSession) throws BonitaException {
        HttpServletRequest httpServletRequest = this.getHttpServletRequest();
        PageReference pageReference = this.pageMappingService.getPage(httpServletRequest, apiSession, this.generateMappingKey(), httpServletRequest.getLocale(), false);
        return pageReference.getPageId();
    }

    protected HttpServletRequest getHttpServletRequest() {
        return ServletUtils.getRequest((Request)this.request);
    }

    public String generateMappingKey() {
        StringBuilder builder = new StringBuilder();
        String requestAsString = this.getHttpServletRequest().getRequestURI();
        String pathTemplate = StringUtils.substringAfter((String)requestAsString, (String)API_EXTENSION_TEMPLATE_PREFIX);
        builder.append(MAPPING_KEY_PREFIX).append(MAPPING_KEY_SEPARATOR).append(this.request.getMethod().getName()).append(MAPPING_KEY_SEPARATOR).append(pathTemplate);
        return builder.toString();
    }

    public ControllerClassName resolveRestApiControllerClassName(PageResourceProviderImpl pageResourceProvider) throws NotFoundException {
        Properties properties = new Properties();
        try (InputStream resourceAsStream = pageResourceProvider.getResourceAsStream("page.properties");){
            properties.load(resourceAsStream);
        }
        catch (IOException e) {
            throw new NotFoundException("error while getting resource:" + this.generateMappingKey());
        }
        String apiExtensionList = (String)properties.get("apiExtensions");
        String[] apiExtensions = apiExtensionList.split(",");
        return this.findMatchingControllerClassName(properties, apiExtensions);
    }

    private ControllerClassName findMatchingControllerClassName(Properties properties, String[] apiExtensions) throws NotFoundException {
        for (String apiExtension : apiExtensions) {
            String method = (String)properties.get(String.format("%s.method", apiExtension.trim()));
            String pathTemplate = (String)properties.get(String.format("%s.pathTemplate", apiExtension.trim()));
            if (pathTemplate != null && pathTemplate.startsWith("/")) {
                pathTemplate = pathTemplate.substring(1);
            }
            String className = (String)properties.get(String.format("%s.className", apiExtension.trim()));
            String classFileName = (String)properties.get(String.format("%s.classFileName", apiExtension.trim()));
            if (!this.extensionMatches(method, pathTemplate)) continue;
            return className != null && !className.isEmpty() ? new ControllerClassName(className, false) : new ControllerClassName(classFileName, true);
        }
        throw new NotFoundException("error while getting resource:" + this.generateMappingKey());
    }

    private boolean extensionMatches(String method, String pathTemplate) {
        return this.request.getMethod().getName().equals(method) && this.getHttpServletRequest().getRequestURI().endsWith(String.format("%s%s", API_EXTENSION_TEMPLATE_PREFIX, pathTemplate));
    }
}

