/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.organization;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.console.common.server.preferences.properties.PropertiesFactory;
import org.bonitasoft.web.rest.model.identity.UserDefinition;
import org.bonitasoft.web.rest.model.identity.UserItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.HumanTaskDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.PersonalContactDataDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.ProfessionalContactDataDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.UserDatastore;
import org.bonitasoft.web.rest.server.framework.api.APIHasAdd;
import org.bonitasoft.web.rest.server.framework.api.APIHasDelete;
import org.bonitasoft.web.rest.server.framework.api.APIHasGet;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.api.APIHasUpdate;
import org.bonitasoft.web.rest.server.framework.api.Datastore;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ValidationError;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ValidationException;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.AbstractStringValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIUser
extends ConsoleAPI<UserItem>
implements APIHasAdd<UserItem>,
APIHasDelete,
APIHasUpdate<UserItem>,
APIHasGet<UserItem>,
APIHasSearch<UserItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)APIUser.class.getName());

    @Override
    protected ItemDefinition<UserItem> defineItemDefinition() {
        return UserDefinition.get();
    }

    @Override
    public String defineDefaultSearchOrder() {
        return "lastname";
    }

    @Override
    public UserItem add(UserItem item) {
        if (StringUtil.isBlank(item.getPassword())) {
            throw new ValidationException(Collections.singletonList(new ValidationError("Password", "%attribute% is mandatory")));
        }
        this.checkPasswordRobustness(item.getPassword());
        return super.add(item);
    }

    @Override
    protected Datastore defineDefaultDatastore() {
        return new UserDatastore(this.getEngineSession());
    }

    private void checkPasswordRobustness(String password) {
        try {
            Class<?> validatorClass = Class.forName(this.getValidatorClassName());
            try {
                Object instanceClass = validatorClass.newInstance();
                AbstractStringValidator validator = (AbstractStringValidator)instanceClass;
                validator.setLocale(this.getLocale());
                validator.check(password);
                if (!validator.getErrors().isEmpty()) {
                    throw new ValidationException(validator.getErrors());
                }
            }
            catch (InstantiationException e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Error while instantiating the class", (Throwable)e);
                }
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Illegal access with the file ", (Throwable)e);
                }
                e.printStackTrace();
            }
        }
        catch (ClassNotFoundException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Class not found", (Throwable)e);
            }
            e.printStackTrace();
        }
    }

    String getValidatorClassName() {
        return PropertiesFactory.getSecurityProperties().getPasswordValidator();
    }

    @Override
    public UserItem update(APIID id, Map<String, String> item) {
        MapUtil.removeIfBlank(item, "password");
        if (item.get("password") != null) {
            this.checkPasswordRobustness(item.get("password"));
        }
        return (UserItem)super.update(id, item);
    }

    @Override
    public UserItem get(APIID id) {
        UserItem item = (UserItem)super.get(id);
        if (item != null) {
            item.setPassword(null);
            String iconPath = item.getIcon();
            if (iconPath == null || iconPath.isEmpty()) {
                item.setIcon("icons/default/icon_user.png");
            }
        }
        return item;
    }

    @Override
    public ItemSearchResult<UserItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        ItemSearchResult<UserItem> results = super.search(page, resultsByPage, search, orders, filters);
        for (UserItem item : results.getResults()) {
            if (item == null) continue;
            item.setPassword(null);
        }
        return results;
    }

    @Override
    public void delete(List<APIID> ids) {
        super.delete(ids);
    }

    @Override
    protected void fillDeploys(UserItem item, List<String> deploys) {
        if (this.isDeployable("manager_id", deploys, item)) {
            item.setDeploy("manager_id", ((UserDatastore)this.getDefaultDatastore()).get(item.getManagerId()));
        }
        if (this.isDeployable("created_by_user_id", deploys, item)) {
            item.setDeploy("created_by_user_id", ((UserDatastore)this.getDefaultDatastore()).get(item.getCreatedByUserId()));
        }
        if (deploys.contains("personnal_data")) {
            item.setDeploy("personnal_data", new PersonalContactDataDatastore(this.getEngineSession()).get(item.getId()));
            item.setAttribute("personnal_data", (String)null);
        }
        if (deploys.contains("professional_data")) {
            item.setDeploy("professional_data", new ProfessionalContactDataDatastore(this.getEngineSession()).get(item.getId()));
            item.setAttribute("professional_data", (String)null);
        }
    }

    @Override
    protected void fillCounters(UserItem item, List<String> counters) {
        if (counters.contains("open_tasks")) {
            item.setAttribute("open_tasks", new HumanTaskDatastore(this.getEngineSession()).getNumberOfOpenTasks(item.getId()));
        }
        if (counters.contains("overdue_tasks")) {
            item.setAttribute("overdue_tasks", new HumanTaskDatastore(this.getEngineSession()).getNumberOfOverdueOpenTasks(item.getId()));
        }
    }
}

