/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.platform;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.PlatformAPIAccessor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.platform.Platform;
import org.bonitasoft.engine.platform.PlatformNotFoundException;
import org.bonitasoft.engine.platform.PlatformState;
import org.bonitasoft.engine.platform.StartNodeException;
import org.bonitasoft.engine.session.PlatformSession;
import org.bonitasoft.web.rest.model.platform.PlatformItem;
import org.bonitasoft.web.rest.server.api.PlatformAPI;
import org.bonitasoft.web.rest.server.framework.api.APIHasGet;
import org.bonitasoft.web.rest.server.framework.api.APIHasUpdate;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.Definitions;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;
import org.bonitasoft.web.toolkit.client.ui.utils.DateFormat;

public class APIPlatform
extends PlatformAPI<PlatformItem>
implements APIHasGet<PlatformItem>,
APIHasUpdate<PlatformItem> {
    @Override
    protected ItemDefinition defineItemDefinition() {
        return Definitions.get("platformInfo");
    }

    @Override
    public PlatformItem update(APIID id, Map<String, String> attributes) {
        String platformState = attributes.get("state");
        try {
            org.bonitasoft.engine.api.PlatformAPI platformAPI = this.getPlatformAPI();
            if (platformAPI.isPlatformCreated()) {
                try {
                    if (platformState.equals("start")) {
                        platformAPI.startNode();
                    } else if (platformState.equals("stop")) {
                        platformAPI.stopNode();
                    }
                }
                catch (StartNodeException sne) {
                    throw new APIException(sne);
                }
            }
            return this.get(null);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public PlatformItem get(APIID id) {
        try {
            org.bonitasoft.engine.api.PlatformAPI platformAPI = this.getPlatformAPI();
            Platform platform = platformAPI.getPlatform();
            String createdDate = DateFormat.dateToSql(new Date(platform.getCreated()));
            PlatformState platformState = platformAPI.getPlatformState();
            String platformStateStr = "";
            if (platformState != null) {
                platformStateStr = platformState.toString();
            }
            PlatformItem platformItem = new PlatformItem(platform.getVersion(), platform.getInitialVersion(), createdDate, platform.getCreatedBy(), platformStateStr);
            return platformItem;
        }
        catch (PlatformNotFoundException ex) {
            PlatformItem platformItem = new PlatformItem();
            return platformItem;
        }
    }

    private org.bonitasoft.engine.api.PlatformAPI getPlatformAPI() {
        try {
            return PlatformAPIAccessor.getPlatformAPI((PlatformSession)this.getPlatformSession());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    protected void fillDeploys(PlatformItem item, List<String> deploys) {
    }

    @Override
    protected void fillCounters(PlatformItem item, List<String> counters) {
    }
}

