/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.profile;

import java.util.List;
import org.bonitasoft.web.rest.model.portal.profile.ProfileMemberDefinition;
import org.bonitasoft.web.rest.model.portal.profile.ProfileMemberItem;
import org.bonitasoft.web.rest.server.api.deployer.DeployerFactory;
import org.bonitasoft.web.rest.server.api.profile.AbstractAPIMember;
import org.bonitasoft.web.rest.server.datastore.ComposedDatastore;
import org.bonitasoft.web.rest.server.datastore.profile.member.AddProfileMemberHelper;
import org.bonitasoft.web.rest.server.datastore.profile.member.DeleteProfileMemberHelper;
import org.bonitasoft.web.rest.server.datastore.profile.member.SearchProfileMembersHelper;
import org.bonitasoft.web.rest.server.engineclient.EngineAPIAccessor;
import org.bonitasoft.web.rest.server.engineclient.EngineClientFactory;
import org.bonitasoft.web.rest.server.engineclient.ProfileMemberEngineClient;
import org.bonitasoft.web.rest.server.framework.api.Datastore;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APIProfileMember
extends AbstractAPIMember<ProfileMemberItem> {
    @Override
    protected ItemDefinition<ProfileMemberItem> defineItemDefinition() {
        return ProfileMemberDefinition.get();
    }

    @Override
    protected Datastore defineDefaultDatastore() {
        ProfileMemberEngineClient engineClient = this.createProfileMemberEngineClient();
        ComposedDatastore<ProfileMemberItem> datastore = new ComposedDatastore<ProfileMemberItem>();
        datastore.setAddHelper(new AddProfileMemberHelper(engineClient));
        datastore.setDeleteHelper(new DeleteProfileMemberHelper(engineClient));
        datastore.setSearchHelper(new SearchProfileMembersHelper(engineClient));
        return datastore;
    }

    @Override
    public String defineDefaultSearchOrder() {
        return "";
    }

    @Override
    protected void fillDeploys(ProfileMemberItem item, List<String> deploys) {
        this.addDeployer(this.getDeployerFactory().createProfileDeployer("profile_id"));
        super.fillDeploys(item, deploys);
    }

    protected DeployerFactory getDeployerFactory() {
        return new DeployerFactory(this.getEngineSession());
    }

    private ProfileMemberEngineClient createProfileMemberEngineClient() {
        return new EngineClientFactory(new EngineAPIAccessor(this.getEngineSession())).createProfileMemberEngineClient();
    }
}

