/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore;

import java.util.List;
import java.util.Map;
import org.bonitasoft.web.rest.server.framework.api.Datastore;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIMethodNotAllowedException;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.IItem;

public class ComposedDatastore<T extends IItem>
extends Datastore
implements DatastoreHasGet<T>,
DatastoreHasSearch<T>,
DatastoreHasAdd<T>,
DatastoreHasUpdate<T>,
DatastoreHasDelete {
    private DatastoreHasGet<T> getHelper;
    private DatastoreHasSearch<T> searchHelper;
    private DatastoreHasUpdate<T> updateHelper;
    private DatastoreHasAdd<T> addHelper;
    private DatastoreHasDelete deleteHelper;

    @Override
    public T get(APIID id) {
        if (this.getHelper != null) {
            return this.getHelper.get(id);
        }
        throw new APIMethodNotAllowedException("GET method not allowed.");
    }

    @Override
    public ItemSearchResult<T> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        if (this.searchHelper != null) {
            return this.searchHelper.search(page, resultsByPage, search, orders, filters);
        }
        throw new APIMethodNotAllowedException("SEARCH method not allowed.");
    }

    @Override
    public T add(T item) {
        if (this.addHelper != null) {
            return this.addHelper.add(item);
        }
        throw new APIMethodNotAllowedException("ADD method not allowed.");
    }

    @Override
    public T update(APIID id, Map<String, String> attributes) {
        if (this.updateHelper != null) {
            return this.updateHelper.update(id, attributes);
        }
        throw new APIMethodNotAllowedException("UPDATE method not allowed.");
    }

    @Override
    public void delete(List<APIID> ids) {
        if (this.deleteHelper == null) {
            throw new APIMethodNotAllowedException("DELETE method not allowed.");
        }
        this.deleteHelper.delete(ids);
    }

    public void setGetHelper(DatastoreHasGet<T> getHelper) {
        this.getHelper = getHelper;
    }

    public void setSearchHelper(DatastoreHasSearch<T> searchHelper) {
        this.searchHelper = searchHelper;
    }

    public void setAddHelper(DatastoreHasAdd<T> addHelper) {
        this.addHelper = addHelper;
    }

    public void setDeleteHelper(DatastoreHasDelete deleteHelper) {
        this.deleteHelper = deleteHelper;
    }
}

