/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.application;

import java.util.List;
import java.util.Map;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.engine.api.ApplicationAPI;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.business.application.Application;
import org.bonitasoft.engine.business.application.ApplicationCreator;
import org.bonitasoft.engine.business.application.ApplicationLink;
import org.bonitasoft.engine.business.application.ApplicationLinkCreator;
import org.bonitasoft.engine.business.application.ApplicationLinkUpdater;
import org.bonitasoft.engine.business.application.ApplicationNotFoundException;
import org.bonitasoft.engine.business.application.ApplicationPage;
import org.bonitasoft.engine.business.application.ApplicationUpdater;
import org.bonitasoft.engine.business.application.IApplication;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.page.Page;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.application.AbstractApplicationItem;
import org.bonitasoft.web.rest.model.application.ApplicationItem;
import org.bonitasoft.web.rest.model.application.ApplicationLinkItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.application.ApplicationFilterCreator;
import org.bonitasoft.web.rest.server.datastore.application.ApplicationItemConverter;
import org.bonitasoft.web.rest.server.datastore.application.ApplicationSearchDescriptorConverter;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class ApplicationDataStore
extends CommonDatastore<AbstractApplicationItem, IApplication>
implements DatastoreHasAdd<AbstractApplicationItem>,
DatastoreHasUpdate<AbstractApplicationItem>,
DatastoreHasGet<AbstractApplicationItem>,
DatastoreHasSearch<AbstractApplicationItem>,
DatastoreHasDelete {
    private final ApplicationAPI applicationAPI;
    private final ApplicationItemConverter converter;
    private final PageAPI pageAPI;
    private static final String CUSTOMPAGE_HOME = "custompage_home";

    public ApplicationDataStore(APISession engineSession, ApplicationAPI applicationAPI, PageAPI pageAPI, ApplicationItemConverter converter) {
        super(engineSession);
        this.applicationAPI = applicationAPI;
        this.pageAPI = pageAPI;
        this.converter = converter;
    }

    @Override
    public void delete(List<APIID> ids) {
        try {
            for (APIID id : ids) {
                this.applicationAPI.deleteApplication(id.toLong().longValue());
            }
        }
        catch (BonitaException e) {
            if (e.getCause() instanceof ApplicationNotFoundException) {
                throw new APIItemNotFoundException("application");
            }
            throw new APIException(e);
        }
    }

    @Override
    public AbstractApplicationItem get(APIID id) {
        try {
            IApplication application = this.applicationAPI.getIApplication(id.toLong().longValue());
            return this.converter.toApplicationItem(application);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    @Deprecated(since="9.0.0")
    public AbstractApplicationItem add(AbstractApplicationItem item) {
        if (item instanceof ApplicationItem) {
            ApplicationItem legacy = (ApplicationItem)item;
            return this.add(legacy);
        }
        if (item instanceof ApplicationLinkItem) {
            ApplicationLinkItem link = (ApplicationLinkItem)item;
            return this.add(link);
        }
        throw new APIException("Unknown application type.");
    }

    @Override
    @Deprecated(since="9.0.0")
    public ApplicationItem add(ApplicationItem item) {
        try {
            Page homePageDef = this.pageAPI.getPageByName(CUSTOMPAGE_HOME);
            ApplicationCreator creator = this.converter.toApplicationCreator(item);
            Application application = this.applicationAPI.createApplication(creator);
            ApplicationPage appHomePage = this.applicationAPI.createApplicationPage(application.getId(), homePageDef.getId(), "home");
            this.applicationAPI.setApplicationHomePage(application.getId(), appHomePage.getId());
            AbstractApplicationItem converted = this.converter.toApplicationItem((IApplication)application);
            if (converted instanceof ApplicationItem) {
                ApplicationItem res = (ApplicationItem)converted;
                return res;
            }
            throw new APIException("Use dedicated API for application links.");
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    @Deprecated(since="9.0.0")
    public ApplicationLinkItem add(ApplicationLinkItem item) {
        try {
            ApplicationLinkCreator creator = this.converter.toApplicationLinkCreator(item);
            ApplicationLink application = this.applicationAPI.createApplicationLink(creator);
            AbstractApplicationItem converted = this.converter.toApplicationItem((IApplication)application);
            if (converted instanceof ApplicationLinkItem) {
                ApplicationLinkItem res = (ApplicationLinkItem)converted;
                return res;
            }
            throw new APIException("Use dedicated API for legacy applications.");
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    @Deprecated(since="9.0.0")
    public AbstractApplicationItem update(APIID id, Map<String, String> attributes) {
        try {
            IApplication app = this.applicationAPI.getIApplication(id.toLong().longValue());
            if (app instanceof Application) {
                ApplicationUpdater applicationUpdater = this.converter.toApplicationUpdater(attributes);
                Application application = this.applicationAPI.updateApplication(id.toLong().longValue(), applicationUpdater);
                return this.converter.toApplicationItem((IApplication)application);
            }
            if (app instanceof ApplicationLink) {
                ApplicationLinkUpdater applicationUpdater = this.converter.toApplicationLinkUpdater(attributes);
                ApplicationLink link = this.applicationAPI.updateApplicationLink(id.toLong().longValue(), applicationUpdater);
                return this.converter.toApplicationItem((IApplication)link);
            }
            throw new APIException("Unknown application type.");
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ItemSearchResult<AbstractApplicationItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsCreator creator = this.makeSearchOptionCreator(page, resultsByPage, search, orders, filters);
        try {
            SearchResult<IApplication> searchResult = this.runSearch(creator);
            return new ItemSearchResult<AbstractApplicationItem>(page, resultsByPage, searchResult.getCount(), this.convertEngineToConsoleItemsList(searchResult.getResult()));
        }
        catch (SearchException e) {
            throw new APIException(e);
        }
    }

    protected SearchOptionsCreator makeSearchOptionCreator(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        return new SearchOptionsCreator(page, resultsByPage, search, new Sorts(orders, this.getSearchDescriptorConverter()), new Filters(filters, new ApplicationFilterCreator(this.getSearchDescriptorConverter())));
    }

    protected SearchResult<IApplication> runSearch(SearchOptionsCreator creator) throws SearchException {
        return this.applicationAPI.searchIApplications(creator.create());
    }

    protected ApplicationSearchDescriptorConverter getSearchDescriptorConverter() {
        return new ApplicationSearchDescriptorConverter();
    }

    @Override
    protected AbstractApplicationItem convertEngineToConsoleItem(IApplication item) {
        return new ApplicationItemConverter(new BonitaHomeFolderAccessor()).toApplicationItem(item);
    }
}

