/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.cases;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.process.ProcessInstance;
import org.bonitasoft.engine.bpm.process.ProcessInstanceNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.cases.CaseItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.cases.CaseItemConverter;
import org.bonitasoft.web.rest.server.datastore.bpm.cases.CaseSarter;
import org.bonitasoft.web.rest.server.engineclient.EngineAPIAccessor;
import org.bonitasoft.web.rest.server.engineclient.EngineClientFactory;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIForbiddenException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIIncorrectIdException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class CaseDatastore
extends CommonDatastore<CaseItem, ProcessInstance>
implements DatastoreHasGet<CaseItem>,
DatastoreHasSearch<CaseItem>,
DatastoreHasDelete,
DatastoreHasAdd<CaseItem>,
DatastoreHasUpdate<CaseItem> {
    public CaseDatastore(APISession engineSession) {
        super(engineSession);
    }

    @Override
    protected CaseItem convertEngineToConsoleItem(ProcessInstance item) {
        return new CaseItemConverter().convert(item);
    }

    public long count(String search, String orders, Map<String, String> filters) {
        return this.search(0, 0, search, orders, filters).getTotal();
    }

    @Override
    protected ItemSearchResult<CaseItem> convertEngineToConsoleSearch(int page, int resultsByPage, SearchResult<ProcessInstance> engineSearchResults) {
        return super.convertEngineToConsoleSearch(page, resultsByPage, engineSearchResults);
    }

    @Override
    public ItemSearchResult<CaseItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        try {
            SearchOptionsBuilder builder = this.buildSearchOptions(page, resultsByPage, search, orders, filters);
            SearchResult<ProcessInstance> searchResult = this.searchProcessInstances(filters, builder.done());
            return this.convertEngineToConsoleSearch(page, resultsByPage, searchResult);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    protected SearchOptionsBuilder buildSearchOptions(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsBuilder builder = SearchOptionsBuilderUtil.buildSearchOptions(page, resultsByPage, orders, search);
        this.addLongFilterToSearchBuilder(filters, builder, "start", "startDate");
        this.addLongFilterToSearchBuilder(filters, builder, "end_date", "endDate");
        this.addLongFilterToSearchBuilder(filters, builder, "last_update_date", "lastUpdate");
        this.addLongFilterToSearchBuilder(filters, builder, "processDefinitionId", "processDefinitionId");
        this.addLongFilterToSearchBuilder(filters, builder, "rootCaseId", "rootProcessInstanceId");
        this.addAddDifferentFromRootIdFilterIfNecessary(filters, builder);
        this.addStringFilterToSearchBuilder(filters, builder, "name", "name");
        this.addLongFilterToSearchBuilder(filters, builder, "started_by", "startedBy");
        this.addStringFilterToSearchBuilder(filters, builder, "searchIndex1Value", "index1");
        this.addStringFilterToSearchBuilder(filters, builder, "searchIndex2Value", "index2");
        this.addStringFilterToSearchBuilder(filters, builder, "searchIndex3Value", "index3");
        this.addStringFilterToSearchBuilder(filters, builder, "searchIndex4Value", "index4");
        this.addStringFilterToSearchBuilder(filters, builder, "searchIndex5Value", "index5");
        this.addCallerFilterToSearchBuilderIfNecessary(filters, builder);
        builder.differentFrom("stateId", (Serializable)Integer.valueOf(ProcessInstanceState.COMPLETED.getId()));
        builder.differentFrom("stateId", (Serializable)Integer.valueOf(ProcessInstanceState.CANCELLED.getId()));
        builder.differentFrom("stateId", (Serializable)Integer.valueOf(ProcessInstanceState.ABORTED.getId()));
        return builder;
    }

    protected void addAddDifferentFromRootIdFilterIfNecessary(Map<String, String> filters, SearchOptionsBuilder builder) {
        if (filters.containsKey("rootCaseId")) {
            builder.differentFrom("id", (Serializable)MapUtil.getValueAsLong(filters, "rootCaseId"));
        }
    }

    protected void addCallerFilterToSearchBuilderIfNecessary(Map<String, String> filters, SearchOptionsBuilder builder) {
        if (!filters.containsKey("caller")) {
            builder.filter("callerId", (Serializable)Integer.valueOf(-1));
        } else if (!"any".equalsIgnoreCase(filters.get("caller"))) {
            builder.filter("callerId", (Serializable)MapUtil.getValueAsLong(filters, "caller"));
        }
    }

    protected SearchResult<ProcessInstance> searchProcessInstances(Map<String, String> filters, SearchOptions searchOptions) throws BonitaException {
        ProcessAPI processAPI = this.getProcessAPI();
        if (filters.containsKey("user_id")) {
            return processAPI.searchOpenProcessInstancesInvolvingUser(MapUtil.getValueAsLong(filters, "user_id").longValue(), searchOptions);
        }
        if (filters.containsKey("supervisor_id")) {
            if (filters.containsKey("state") && ("failed".equalsIgnoreCase(filters.get("state")) || "error".equalsIgnoreCase(filters.get("state")))) {
                return processAPI.searchFailedProcessInstancesSupervisedBy(MapUtil.getValueAsLong(filters, "supervisor_id").longValue(), searchOptions);
            }
            return processAPI.searchOpenProcessInstancesSupervisedBy(MapUtil.getValueAsLong(filters, "supervisor_id").longValue(), searchOptions);
        }
        if (filters.containsKey("state") && ("failed".equalsIgnoreCase(filters.get("state")) || "error".equalsIgnoreCase(filters.get("state")))) {
            return processAPI.searchFailedProcessInstances(searchOptions);
        }
        return processAPI.searchProcessInstances(searchOptions);
    }

    @Override
    public CaseItem get(APIID id) {
        try {
            return this.convertEngineToConsoleItem(this.getProcessAPI().getProcessInstance(id.toLong().longValue()));
        }
        catch (ProcessInstanceNotFoundException e) {
            return null;
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public void delete(List<APIID> ids) {
        try {
            ProcessAPI processApi = this.getProcessAPI();
            for (APIID id : ids) {
                processApi.deleteProcessInstance(id.toLong().longValue());
                processApi.deleteArchivedProcessInstancesInAllStates(id.toLong().longValue());
            }
        }
        catch (BonitaException e) {
            if (e.getCause() instanceof ProcessInstanceNotFoundException) {
                throw new APIItemNotFoundException("cases");
            }
            throw new APIException(e);
        }
    }

    @Override
    public CaseItem add(CaseItem caseItem) {
        EngineClientFactory factory = new EngineClientFactory(new EngineAPIAccessor(this.getEngineSession()));
        return new CaseSarter(caseItem, factory.createCaseEngineClient(), factory.createProcessEngineClient()).start();
    }

    public ProcessAPI getProcessAPI() throws BonitaException {
        return TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
    }

    @Override
    public CaseItem update(APIID id, Map<String, String> attributes) {
        String state = MapUtil.getValue(attributes, "state", null);
        try {
            ProcessAPI processApi = this.getProcessAPI();
            if (state == null) {
                throw new APIForbiddenException("Only statecan be updated on a case");
            }
            ProcessInstanceState instanceState = ProcessInstanceState.valueOf((String)state.toUpperCase());
            if (instanceState == ProcessInstanceState.CANCELLED) {
                processApi.cancelProcessInstance(id.toLong().longValue());
                return null;
            }
            throw new APIForbiddenException("Can't update a case state to \"" + state + "\"");
        }
        catch (BonitaException e) {
            if (e.getCause() instanceof ProcessInstanceNotFoundException) {
                throw new APIItemNotFoundException("cases");
            }
            throw new APIException(e);
        }
        catch (IllegalArgumentException e) {
            throw new APIIncorrectIdException("Case state \"" + state + "\" doesn't exist");
        }
    }
}

