/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.cases;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.bonitasoft.console.common.server.api.CommandCaller;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.comment.Comment;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.search.Order;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.cases.CommentItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class CommentDatastore
extends CommonDatastore<CommentItem, Comment>
implements DatastoreHasAdd<CommentItem>,
DatastoreHasSearch<CommentItem> {
    private static final String[][] SORTABLE_FIELDS_LUT = new String[][]{{"postDate", "postdate"}};
    private static final String COMMAND_SEARCH_COMMENTS_SUPERVISEDBY = "searchSCommentSupervisedBy";
    private static final String PROPERTY_SEARCH_OPTION_KEY = "SEARCH_OPTIONS_KEY";
    private static final String PROPERTY_SUPERVISOR_ID_KEY = "supervisorId";

    public CommentDatastore(APISession engineSession) {
        super(engineSession);
    }

    @Override
    public ItemSearchResult<CommentItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsBuilder builder = SearchOptionsBuilderUtil.buildSearchOptions(page, resultsByPage, "", search);
        this.adjustSearchBuilder(filters, builder);
        if (orders != null && !orders.isEmpty()) {
            String[] sort = orders.split(" ");
            for (int i = 0; i < SORTABLE_FIELDS_LUT.length; ++i) {
                if (!sort[0].equals(SORTABLE_FIELDS_LUT[i][0])) continue;
                builder.sort(SORTABLE_FIELDS_LUT[i][1], Order.valueOf((String)sort[1]));
            }
        }
        SearchResult<Comment> engineSearchResults = null;
        APIID teamManagerAPIID = APIID.makeAPIID(filters.get("team_manager_id"));
        APIID supervisorAPIID = APIID.makeAPIID(filters.get("supervisor_id"));
        APIID userAPIID = APIID.makeAPIID(filters.get("user_id"));
        engineSearchResults = teamManagerAPIID != null && teamManagerAPIID.isValidLongID() ? this.runTeamManagerSearch(teamManagerAPIID.toLong(), builder) : (supervisorAPIID != null && supervisorAPIID.isValidLongID() ? this.runSupervisorSearch(supervisorAPIID.toLong(), builder) : (userAPIID != null && userAPIID.isValidLongID() ? this.runUserSearch(userAPIID.toLong(), builder) : this.runCustomSearch(builder)));
        if (engineSearchResults != null) {
            ArrayList<CommentItem> consoleSearchResults = new ArrayList<CommentItem>();
            for (Comment comment : engineSearchResults.getResult()) {
                consoleSearchResults.add(this.convertEngineToConsoleItem(comment));
            }
            return new ItemSearchResult<CommentItem>(page, resultsByPage, engineSearchResults.getCount(), consoleSearchResults);
        }
        throw new APIException("Search failed for the following parameters <page: " + page + " - resulsByPage: " + resultsByPage + " - search: " + search + " - filters: " + String.valueOf(filters) + " - orders: " + orders + ">");
    }

    private SearchResult<Comment> runTeamManagerSearch(long teamManagerId, SearchOptionsBuilder builder) {
        try {
            ProcessAPI processAPI = TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
            return processAPI.searchCommentsManagedBy(teamManagerId, builder.done());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    private SearchResult<Comment> runUserSearch(long userId, SearchOptionsBuilder builder) {
        try {
            ProcessAPI processAPI = TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
            return processAPI.searchCommentsInvolvingUser(userId, builder.done());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    private SearchResult<Comment> runCustomSearch(SearchOptionsBuilder builder) {
        try {
            ProcessAPI processAPI = TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
            return processAPI.searchComments(builder.done());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    private SearchResult<Comment> runSupervisorSearch(long supervisorId, SearchOptionsBuilder builder) {
        return (SearchResult)new CommandCaller(this.getEngineSession(), COMMAND_SEARCH_COMMENTS_SUPERVISEDBY).addParameter(PROPERTY_SEARCH_OPTION_KEY, (Serializable)builder.done()).addParameter(PROPERTY_SUPERVISOR_ID_KEY, Long.valueOf(supervisorId)).run();
    }

    @Override
    public CommentItem add(CommentItem item) {
        try {
            ProcessAPI processAPI = TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
            return this.convertEngineToConsoleItem(processAPI.addProcessComment(item.getProcessInstanceId().toLong().longValue(), item.getContent()));
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    private void adjustSearchBuilder(Map<String, String> filters, SearchOptionsBuilder builder) {
        this.addStringFilterToSearchBuilder(filters, builder, "processInstanceId", "processInstanceId");
    }

    @Override
    protected CommentItem convertEngineToConsoleItem(Comment engineItem) {
        if (engineItem == null) {
            return null;
        }
        CommentItem consoleItem = new CommentItem();
        consoleItem.setId(engineItem.getId());
        consoleItem.setUserId(engineItem.getUserId());
        consoleItem.setProcessInstanceId(engineItem.getProcessInstanceId());
        consoleItem.setPostDate(engineItem.getPostDate());
        consoleItem.setContent(engineItem.getContent());
        return consoleItem;
    }
}

