/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.utils;

import org.bonitasoft.engine.search.Order;
import org.bonitasoft.web.rest.server.datastore.converter.AttributeConverter;
import org.bonitasoft.web.rest.server.datastore.converter.EmptyAttributeConverter;

public class Sort {
    public static final Order DEFAULT_ORDER = Order.ASC;
    private static final String SEPARATOR = " ";
    private final String field;
    private final Order order;
    private final AttributeConverter converter;

    public Sort(String sortValue, AttributeConverter converter) {
        this.converter = converter;
        this.field = this.getSortedFieldValue(sortValue);
        this.order = this.getOrder(sortValue);
    }

    public Sort(String sortValue) {
        this(sortValue, new EmptyAttributeConverter());
    }

    private Order getOrder(String sortValue) {
        String[] split = sortValue.split(SEPARATOR);
        if (split.length > 1) {
            return Order.valueOf((String)split[1].toUpperCase());
        }
        return DEFAULT_ORDER;
    }

    private String getSortedFieldValue(String sortValue) {
        String fieldValue = sortValue.split(SEPARATOR)[0];
        String convertedFieldValue = this.converter.convert(fieldValue);
        return convertedFieldValue != null ? convertedFieldValue : fieldValue;
    }

    public String getField() {
        return this.field;
    }

    public Order getOrder() {
        return this.order;
    }

    public String toString() {
        return this.getField() + SEPARATOR + String.valueOf(this.getOrder());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sort other = (Sort)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        return this.order == other.order;
    }
}

