/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.utils;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.web.rest.server.datastore.utils.Variable;
import org.bonitasoft.web.rest.server.datastore.utils.VariableMapper;
import org.bonitasoft.web.rest.server.framework.json.JacksonDeserializer;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;

public class VariablesMapper {
    private final List<VariableMapper> variables;

    protected VariablesMapper(List<Variable> variables, JacksonDeserializer deserializer) {
        this.variables = this.convertToMappers(variables, deserializer);
    }

    public static VariablesMapper fromJson(String json) {
        JacksonDeserializer deserializer = new JacksonDeserializer();
        List<Variable> variables = deserializer.deserializeList(json, Variable.class);
        return new VariablesMapper(variables, deserializer);
    }

    private List<VariableMapper> convertToMappers(List<Variable> list, JacksonDeserializer deserializer) {
        ArrayList<VariableMapper> mappers = new ArrayList<VariableMapper>();
        for (Variable variable : list) {
            if (StringUtil.isBlank(variable.getName())) continue;
            mappers.add(new VariableMapper(variable, deserializer));
        }
        return mappers;
    }

    public List<VariableMapper> getVariables() {
        return this.variables;
    }
}

