/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.engineclient;

import java.util.List;
import org.bonitasoft.engine.api.IdentityAPI;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.identity.CustomUserInfo;
import org.bonitasoft.engine.identity.CustomUserInfoDefinition;
import org.bonitasoft.engine.identity.CustomUserInfoDefinitionCreator;
import org.bonitasoft.engine.identity.CustomUserInfoValue;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class CustomUserInfoEngineClient {
    private final IdentityAPI identity;

    public CustomUserInfoEngineClient(IdentityAPI identity) {
        this.identity = identity;
    }

    public CustomUserInfoDefinition createDefinition(CustomUserInfoDefinitionCreator creator) {
        try {
            return this.identity.createCustomUserInfoDefinition(creator);
        }
        catch (CreationException e) {
            throw new APIException(new T_("An error occurred while creating a definition"), (Throwable)e);
        }
    }

    public void deleteDefinition(long id) {
        try {
            this.identity.deleteCustomUserInfoDefinition(id);
        }
        catch (DeletionException e) {
            throw new APIException(new T_("An error occurred while deleting an item with the id %id%", new Arg("id", id)), (Throwable)e);
        }
    }

    public List<CustomUserInfoDefinition> listDefinitions(int startIndex, int maxResult) {
        return this.identity.getCustomUserInfoDefinitions(startIndex, maxResult);
    }

    public long countDefinitions() {
        return this.identity.getNumberOfCustomInfoDefinitions();
    }

    public List<CustomUserInfo> listCustomInformation(long userId, int startIndex, int maxResult) {
        return this.identity.getCustomUserInfo(userId, startIndex, maxResult);
    }

    public SearchResult<CustomUserInfoValue> searchCustomUserInfoValues(SearchOptions options) {
        return this.identity.searchCustomUserInfoValues(options);
    }

    public CustomUserInfoValue setCustomUserInfoValue(long definitionId, long userId, String value) {
        try {
            return this.identity.setCustomUserInfoValue(definitionId, userId, value);
        }
        catch (UpdateException e) {
            throw new APIItemNotFoundException("customuserinfo", APIID.makeAPIID(definitionId, userId));
        }
    }
}

