/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.framework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.console.common.server.i18n.I18n;
import org.bonitasoft.web.rest.server.framework.API;
import org.bonitasoft.web.rest.server.framework.APIs;
import org.bonitasoft.web.rest.server.framework.exception.APIMissingIdException;
import org.bonitasoft.web.rest.server.framework.json.JSonSimpleDeserializer;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.RestRequestParser;
import org.bonitasoft.web.toolkit.client.common.AbstractTreeNode;
import org.bonitasoft.web.toolkit.client.common.Tree;
import org.bonitasoft.web.toolkit.client.common.TreeLeaf;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIIncorrectIdException;
import org.bonitasoft.web.toolkit.client.common.json.JSonItemReader;
import org.bonitasoft.web.toolkit.client.common.json.JSonItemWriter;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.IItem;
import org.bonitasoft.web.toolkit.client.data.item.Item;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ValidatorEngine;
import org.bonitasoft.web.toolkit.server.ServletCall;

public class APIServletCall
extends ServletCall {
    public static final String PARAMETER_COUNTER = "n";
    public static final String PARAMETER_DEPLOY = "d";
    public static final String PARAMETER_FILTER = "f";
    public static final String PARAMETER_SEARCH = "s";
    public static final String PARAMETER_ORDER = "o";
    public static final String PARAMETER_LIMIT = "c";
    public static final String PARAMETER_PAGE = "p";
    public static final String PARAMETER_QUERY = "q";
    protected API<? extends IItem> api;
    private String apiName;
    private String resourceName;
    private APIID id;

    public APIServletCall(HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
    }

    public APIServletCall() {
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public APIID getId() {
        return this.id;
    }

    private IItem getJSonStreamAsItem() {
        IItem item = JSonItemReader.parseItem(this.getInputStream(), this.api.getItemDefinition());
        ValidatorEngine.validate(item, false);
        return item;
    }

    @Override
    protected final void parseRequest(HttpServletRequest request, HttpServletResponse response) {
        this.parsePath(request);
        I18n.getInstance();
        this.api = APIs.get(this.apiName, this.resourceName);
        this.api.setCaller(this);
        super.parseRequest(request, response);
    }

    void parsePath(HttpServletRequest request) {
        RestRequestParser restRequestParser = new RestRequestParser(request).invoke();
        APIID resourceQualifiers = restRequestParser.getResourceQualifiers();
        if (resourceQualifiers != null && resourceQualifiers.getIds().size() > 0 && this.isAnyNumberIdNegativeOrZero(resourceQualifiers.getIds())) {
            throw new APIIncorrectIdException("Id must be non-zero positive for " + restRequestParser.getApiName() + " on resource " + restRequestParser.getResourceName());
        }
        this.id = resourceQualifiers;
        this.apiName = restRequestParser.getApiName();
        this.resourceName = restRequestParser.getResourceName();
    }

    private boolean isAnyNumberIdNegativeOrZero(List<String> ids) {
        for (String id : ids) {
            try {
                if (Long.parseLong(id) > 0L) continue;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return false;
    }

    @Override
    public final void doGet() {
        try {
            if (this.id != null) {
                this.output(this.api.runGet(this.id, this.getParameterAsList(PARAMETER_DEPLOY), this.getParameterAsList(PARAMETER_COUNTER)));
            } else {
                if (this.countParameters() == 0) {
                    throw new APIMissingIdException(this.getRequestURL());
                }
                ItemSearchResult<? extends IItem> result = this.api.runSearch(Integer.parseInt(this.getParameter(PARAMETER_PAGE, "0")), Integer.parseInt(this.getParameter(PARAMETER_LIMIT, "10")), this.getParameter(PARAMETER_SEARCH), this.getParameter(PARAMETER_ORDER), this.parseFilters(this.getParameterAsList(PARAMETER_FILTER)), this.getParameterAsList(PARAMETER_DEPLOY), this.getParameterAsList(PARAMETER_COUNTER));
                this.head("Content-Range", result.getPage() + "-" + result.getLength() + "/" + result.getTotal());
                this.output(result.getResults());
            }
        }
        catch (APIException e) {
            e.setApi(this.apiName);
            e.setResource(this.resourceName);
            throw e;
        }
    }

    @Override
    protected void output(Object object) {
        super.output(object);
    }

    @Override
    protected void head(String name, String value) {
        super.head(name, value);
    }

    @Override
    public final void doPost() {
        try {
            IItem jSonStreamAsItem = this.getJSonStreamAsItem();
            IItem outputItem = this.api.runAdd(jSonStreamAsItem);
            this.output(JSonItemWriter.itemToJSON(outputItem));
        }
        catch (APIException e) {
            e.setApi(this.apiName);
            e.setResource(this.resourceName);
            throw e;
        }
    }

    @Override
    public final void doPut() {
        try {
            if (this.id == null) {
                throw new APIMissingIdException(this.getRequestURL());
            }
            String inputStream = this.getInputStream();
            if (inputStream.length() == 0) {
                this.api.runUpdate(this.id, new HashMap<String, String>());
                return;
            }
            Item.setApplyValidatorMandatoryByDefault(false);
            IItem item = this.getJSonStreamAsItem();
            this.api.runUpdate(this.id, this.getAttributesWithDeploysAsJsonString(item));
        }
        catch (APIException e) {
            e.setApi(this.apiName);
            e.setResource(this.resourceName);
            throw e;
        }
    }

    private HashMap<String, String> getAttributesWithDeploysAsJsonString(IItem item) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(item.getAttributes());
        for (Map.Entry<String, IItem> deploy : item.getDeploys().entrySet()) {
            map.put(deploy.getKey(), deploy.getValue().toJson());
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void doDelete() {
        try {
            ArrayList<APIID> ids = new ArrayList<APIID>();
            if (this.id == null) {
                String inputStream = this.getInputStream();
                if (inputStream.length() == 0) {
                    throw new APIMissingIdException("Id of the element to delete is missing [" + inputStream + "]");
                }
                AbstractTreeNode<String> tree = JSonSimpleDeserializer.unserializeTree(inputStream);
                if (!(tree instanceof Tree)) throw new APIMissingIdException("Id of the elements to delete are missing or misswritten \"" + inputStream + "\"");
                List nodes = ((Tree)tree).getNodes();
                for (AbstractTreeNode node : nodes) {
                    if (node instanceof Tree) {
                        ids.add(APIID.makeAPIID(((Tree)node).getValues()));
                        continue;
                    }
                    if (!(node instanceof TreeLeaf)) throw new APIMissingIdException("Id of the elements to delete are missing or misswritten \"" + inputStream + "\"");
                    ids.add(APIID.makeAPIID((String)((TreeLeaf)node).getValue()));
                }
            } else {
                ids.add(this.id);
            }
            this.api.runDelete(ids);
            return;
        }
        catch (APIException e) {
            e.setApi(this.apiName);
            e.setResource(this.resourceName);
            throw e;
        }
    }

    private Map<String, String> parseFilters(List<String> parameters) {
        if (parameters == null) {
            return null;
        }
        HashMap<String, String> results = new HashMap<String, String>();
        for (String parameter : parameters) {
            String[] split = parameter.split("=");
            if (split.length < 2) {
                results.put(split[0], null);
                continue;
            }
            results.put(split[0], split[1]);
        }
        return results;
    }
}

