/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.common.exception.http;

import org.bonitasoft.web.toolkit.client.common.json.JSonSerializer;
import org.bonitasoft.web.toolkit.client.common.json.JSonUtil;

public class JsonExceptionSerializer {
    private final StringBuilder json;

    public JsonExceptionSerializer(Throwable exception) {
        if (exception == null) {
            throw new IllegalArgumentException("exception cannot be null");
        }
        this.json = this.serialize(exception);
    }

    private StringBuilder serialize(Throwable e) {
        StringBuilder json = new StringBuilder().append("{");
        json.append(this.exceptionInnerJson(e));
        if (e.getCause() != null && e.getCause() != e) {
            json.append(",");
            json.append(JSonUtil.quote("cause")).append(":{").append(this.exceptionInnerJson(e.getCause())).append("}");
        }
        return json;
    }

    private String exceptionInnerJson(Throwable e) {
        return JSonUtil.quote("exception") + ":" + JSonUtil.quote(e.getClass().toString()) + "," + JSonUtil.quote("message") + ":" + JSonUtil.quote(e.getMessage());
    }

    public String end() {
        return this.json.append("}").toString();
    }

    public JsonExceptionSerializer appendAttribute(String name, Object value) {
        this.addNextAttribute(this.json, name, value);
        return this;
    }

    private void addNextAttribute(StringBuilder json, String name, Object value) {
        if (value != null) {
            json.append(",");
            json.append(JSonUtil.quote(name)).append(":").append(JSonSerializer.serialize(value));
        }
    }
}

