/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.common.json;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bonitasoft.web.toolkit.client.common.AbstractTreeNode;
import org.bonitasoft.web.toolkit.client.common.Tree;
import org.bonitasoft.web.toolkit.client.common.TreeIndexed;
import org.bonitasoft.web.toolkit.client.common.TreeLeaf;
import org.bonitasoft.web.toolkit.client.common.json.JSonUnserializer;
import org.bonitasoft.web.toolkit.client.data.item.IItem;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class JSonItemReader {
    public static final boolean APPLY_VALIDATORS = true;
    private static JSonUnserializer UNSERIALIZER = null;

    public static void setUnserializer(JSonUnserializer unserializer) {
        UNSERIALIZER = unserializer;
    }

    public static Map<String, String> parseMap(String json) {
        AbstractTreeNode<String> tree = UNSERIALIZER._unserializeTree(json);
        if (!(tree instanceof TreeIndexed)) {
            return new HashMap<String, String>();
        }
        return JSonItemReader.parseMap((TreeIndexed)tree);
    }

    private static Map<String, String> parseMap(TreeIndexed<String> tree) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : tree.getValues().entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <E extends IItem> E parseItem(String json, ItemDefinition<E> itemDefinition) {
        AbstractTreeNode<String> tree = UNSERIALIZER._unserializeTree(json);
        if (tree instanceof Tree && !((tree = ((Tree)tree).get(0)) instanceof TreeIndexed)) {
            return itemDefinition.createItem();
        }
        return JSonItemReader.parseItem((TreeIndexed)tree, itemDefinition);
    }

    private static <E extends IItem> E parseItem(TreeIndexed<String> tree, ItemDefinition<E> itemDefinition) {
        return JSonItemReader.parseItem(tree, itemDefinition, true);
    }

    private static <E extends IItem> E parseItem(TreeIndexed<String> tree, ItemDefinition<E> itemDefinition, boolean applyValidators) {
        Optional<IItem> discriminatedItem = itemDefinition.getDiscriminatedHelper().map(h -> (IItem)h.findItemCreator(tree).get());
        IItem item = discriminatedItem.orElseGet(itemDefinition::createItem);
        item.setApplyValidators(applyValidators);
        for (Map.Entry<String, AbstractTreeNode<String>> entry : tree.getNodes().entrySet()) {
            if (entry.getValue() instanceof TreeLeaf) {
                item.setAttribute(entry.getKey(), (String)((TreeLeaf)entry.getValue()).getValue());
                continue;
            }
            if (entry.getValue() instanceof TreeIndexed) {
                item.setDeploy(entry.getKey(), (IItem)JSonItemReader.parseItem((TreeIndexed)entry.getValue(), itemDefinition.getDeployDefinition(entry.getKey())));
                continue;
            }
            if (!(entry.getValue() instanceof Tree)) continue;
            item.setAttribute(entry.getKey(), entry.getValue().toJson());
        }
        return (E)item;
    }
}

